/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.User;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.JsonBody;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.OrganizationRoute;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.rest.model.BlueUserContainer;
import io.jenkins.blueocean.rest.model.GenericResource;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.UserContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.export.ExportedBean;
import org.kohsuke.stapler.verb.DELETE;
import org.kohsuke.stapler.verb.PUT;

public class OrganizationImpl
extends BlueOrganization
implements OrganizationResolver.ItemGroupProvider {
    private final String name;
    private final ItemGroup group;
    private final UserContainerImpl users = new UserContainerImpl((Reachable)this);

    public OrganizationImpl(String name, ItemGroup group) {
        this.name = name;
        this.group = group;
    }

    public String getName() {
        return this.name;
    }

    public ItemGroup getGroup() {
        return this.group;
    }

    public String getDisplayName() {
        return "Jenkins";
    }

    public BluePipelineContainer getPipelines() {
        return new PipelineContainerImpl(this.group);
    }

    @WebMethod(name={""})
    @DELETE
    public void delete() {
        throw new ServiceException.NotImplementedException("Not implemented yet");
    }

    @WebMethod(name={""})
    @PUT
    public void update(@JsonBody OrganizationImpl given) throws IOException {
        given.validate();
        throw new ServiceException.NotImplementedException("Not implemented yet");
    }

    private void validate() {
    }

    public BlueUserContainer getUsers() {
        return this.users;
    }

    public BlueUser getUser() {
        User user = User.current();
        if (user == null) {
            throw new ServiceException.NotFoundException("No authenticated user found");
        }
        return new UserImpl(user, (Reachable)new UserContainerImpl((Reachable)this));
    }

    public Link getLink() {
        return ApiHead.INSTANCE().getLink().rel("organizations/" + this.getName());
    }

    public Object getDynamic(String route) {
        for (OrganizationRoute organizationRoute : ExtensionList.lookup(OrganizationRoute.class)) {
            if (organizationRoute.getUrlName() == null || !organizationRoute.getUrlName().equals(route)) continue;
            return this.wrap(organizationRoute);
        }
        for (Action action : Jenkins.getInstance().getActions()) {
            String urlName = action.getUrlName();
            if (urlName == null || !urlName.equals(route)) continue;
            return this.wrap(action);
        }
        return null;
    }

    private Object wrap(Object action) {
        if (this.isExportedBean(action.getClass())) {
            return action;
        }
        return new GenericResource(action);
    }

    private boolean isExportedBean(Class clz) {
        return clz.getAnnotation(ExportedBean.class) != null;
    }
}

