/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueTestResultFactory;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueTestResult;
import io.jenkins.blueocean.rest.model.BlueTestResultContainer;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public class BlueTestResultContainerImpl
extends BlueTestResultContainer {
    private final Run<?, ?> run;

    public BlueTestResultContainerImpl(BlueRun parent, Run<?, ?> run) {
        super(parent);
        this.run = run;
    }

    public BlueTestResult get(final String name) {
        BlueTestResultFactory.Result resolved = BlueTestResultFactory.resolve(this.run, (Reachable)this.parent);
        this.checkFoundTests(resolved);
        BlueTestResult testResult = (BlueTestResult)Iterables.find((Iterable)resolved.results, (Predicate)new Predicate<BlueTestResult>(){

            public boolean apply(@Nullable BlueTestResult input) {
                return input != null && input.getId().equals(name);
            }
        }, null);
        if (testResult == null) {
            throw new ServiceException.NotFoundException("not found");
        }
        return testResult;
    }

    @Nonnull
    public Iterator<BlueTestResult> iterator() {
        BlueTestResultFactory.Result resolved = BlueTestResultFactory.resolve(this.run, (Reachable)this.parent);
        this.checkFoundTests(resolved);
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request != null) {
            String status = request.getParameter("status");
            String[] atoms = StringUtils.split((String)status, (char)',');
            Predicate predicate = Predicates.alwaysFalse();
            if (atoms != null && atoms.length > 0) {
                for (String statusString : atoms) {
                    BlueTestResult.Status queryStatus;
                    try {
                        queryStatus = BlueTestResult.Status.valueOf((String)statusString.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new ServiceException.BadRequestExpception("bad status " + status, (Throwable)e);
                    }
                    predicate = Predicates.or((Predicate)predicate, (Predicate)new StatusPredicate(queryStatus));
                }
                return Iterables.filter((Iterable)resolved.results, (Predicate)predicate).iterator();
            }
        }
        return resolved.results.iterator();
    }

    private void checkFoundTests(BlueTestResultFactory.Result resolved) {
        if (resolved.summary == null || resolved.results == null) {
            throw new ServiceException.NotFoundException("no tests");
        }
    }

    static class StatusPredicate
    implements Predicate<BlueTestResult> {
        private final BlueTestResult.Status status;

        StatusPredicate(BlueTestResult.Status status) {
            this.status = status;
        }

        public boolean apply(@Nullable BlueTestResult input) {
            return input != null && input.getStatus().equals((Object)this.status);
        }
    }
}

