/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import io.jenkins.blueocean.rest.model.BlueArtifactContainer;
import io.jenkins.blueocean.service.embedded.rest.ArtifactImpl;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import jenkins.util.VirtualFile;
import org.kohsuke.stapler.Stapler;

public class ArtifactContainerImpl
extends BlueArtifactContainer {
    private final Run run;
    private final Link self;

    public ArtifactContainerImpl(Run r, Reachable parent) {
        this.run = r;
        this.self = parent.getLink().rel("artifacts");
    }

    public Link getLink() {
        return this.self;
    }

    public BlueArtifact get(final String name) {
        final VirtualFile file = this.run.getArtifactManager().root().child(name);
        try {
            if (file == null || !file.exists() || !file.isFile()) {
                return null;
            }
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Something is wrong with an artifact", (Throwable)e);
        }
        return new BlueArtifact(){

            public String getName() {
                return file.getName();
            }

            public String getPath() {
                return name;
            }

            public String getUrl() {
                return Stapler.getCurrentRequest().getContextPath() + "/" + ArtifactContainerImpl.this.run.getUrl() + "artifact/" + name;
            }

            public long getSize() {
                try {
                    return file.length();
                }
                catch (IOException e) {
                    throw new ServiceException.UnexpectedErrorException("qError getting file length", (Throwable)e);
                }
            }

            public Link getLink() {
                return new Link(this.getUrl());
            }
        };
    }

    public Iterator<BlueArtifact> iterator(int start, int limit) {
        List artifactsUpTo = this.run.getArtifactsUpTo(limit);
        if (start >= artifactsUpTo.size()) {
            return Iterators.emptyIterator();
        }
        int calculatedLimit = limit;
        if (calculatedLimit > artifactsUpTo.size()) {
            calculatedLimit = artifactsUpTo.size();
        }
        List artifacts = artifactsUpTo.subList(start, calculatedLimit);
        return Iterators.transform(artifacts.iterator(), (Function)new Function<Run.Artifact, BlueArtifact>(){

            public BlueArtifact apply(@Nullable Run.Artifact artifact) {
                if (artifact == null) {
                    return null;
                }
                return new ArtifactImpl(ArtifactContainerImpl.this.run, artifact, (Reachable)ArtifactContainerImpl.this);
            }
        });
    }

    public Iterator<BlueArtifact> iterator() {
        throw new ServiceException.NotImplementedException("Not implemented");
    }
}

