/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.favorite.Favorites;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.OrganizationResolver;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineScm;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.RunContainerImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.DELETE;

@Capability(value={"hudson.model.Job"})
public class AbstractPipelineImpl
extends BluePipeline {
    private final Job job;
    protected final BlueOrganization org;
    public static final Predicate<Run> isRunning = new Predicate<Run>(){

        public boolean apply(Run r) {
            return r != null && r.isBuilding();
        }
    };

    protected AbstractPipelineImpl(Job job) {
        this.job = job;
        this.org = OrganizationResolver.getInstance().getContainingOrg((Item)job);
    }

    public String getOrganization() {
        return this.org.getName();
    }

    public String getName() {
        return this.job.getName();
    }

    public String getDisplayName() {
        return this.job.getDisplayName();
    }

    public Integer getWeatherScore() {
        return this.job.getBuildHealth().getScore();
    }

    public BlueRun getLatestRun() {
        if (this.job.getLastBuild() == null) {
            return null;
        }
        return AbstractRunImpl.getBlueRun(this.job.getLastBuild(), (Reachable)this);
    }

    public Long getEstimatedDurationInMillis() {
        return this.job.getEstimatedDuration();
    }

    public String getLastSuccessfulRun() {
        if (this.job.getLastSuccessfulBuild() != null) {
            String id = this.job.getLastSuccessfulBuild().getId();
            return Stapler.getCurrentRequest().getRootPath() + this.getLink().getHref() + "runs/" + id + "/";
        }
        return null;
    }

    public BlueRunContainer getRuns() {
        return new RunContainerImpl(this, this.job);
    }

    public Collection<BlueActionProxy> getActions() {
        return ActionProxiesImpl.getActionProxies(this.job.getAllActions(), (Reachable)this);
    }

    @Navigable
    public BlueQueueContainer getQueue() {
        return new QueueContainerImpl(this);
    }

    @WebMethod(name={""})
    @DELETE
    public void delete() throws IOException, InterruptedException {
        this.job.delete();
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestExpception("Must provide pipeline name");
        }
        FavoriteUtil.toggle(favoriteAction, (Item)this.job);
        return FavoriteUtil.getFavorite((Item)this.job, new Reachable(){

            public Link getLink() {
                return AbstractPipelineImpl.this.getLink().ancestor();
            }
        });
    }

    public String getFullName() {
        return this.job.getFullName();
    }

    public String getFullDisplayName() {
        return AbstractPipelineImpl.getFullDisplayName(this.job.getParent(), Util.rawEncode((String)this.job.getDisplayName()));
    }

    public static String getFullDisplayName(@Nonnull ItemGroup parent, @Nullable String displayName) {
        String name = parent.getDisplayName();
        if (name.length() == 0) {
            return displayName;
        }
        if (name.length() > 0 && parent instanceof AbstractItem) {
            if (displayName == null) {
                return AbstractPipelineImpl.getFullDisplayName(((AbstractItem)parent).getParent(), String.format("%s", Util.rawEncode((String)name)));
            }
            return AbstractPipelineImpl.getFullDisplayName(((AbstractItem)parent).getParent(), String.format("%s/%s", Util.rawEncode((String)name), displayName));
        }
        return displayName;
    }

    public Link getLink() {
        return this.org.getLink().rel("pipelines").rel(AbstractPipelineImpl.getRecursivePathFromFullName(this));
    }

    public static String getRecursivePathFromFullName(BluePipeline pipeline) {
        StringBuilder pipelinePath = new StringBuilder();
        String[] names = pipeline.getFullName().split("/");
        int count = 1;
        if (names.length > 1) {
            for (String n : names) {
                if (count == 1) {
                    pipelinePath.append(n);
                } else {
                    pipelinePath.append("/pipelines/").append(n);
                }
                ++count;
            }
        } else {
            pipelinePath.append(pipeline.getFullName());
        }
        return pipelinePath.toString();
    }

    public List<Object> getParameters() {
        return AbstractPipelineImpl.getParameterDefinitions(this.job);
    }

    public static List<Object> getParameterDefinitions(Job job) {
        ParametersDefinitionProperty pp = (ParametersDefinitionProperty)job.getProperty(ParametersDefinitionProperty.class);
        ArrayList<Object> pds = new ArrayList<Object>();
        if (pp != null) {
            for (ParameterDefinition pd : pp.getParameterDefinitions()) {
                pds.add(pd);
            }
        }
        return pds;
    }

    public Job getJob() {
        return this.job;
    }

    public Map<String, Boolean> getPermissions() {
        return AbstractPipelineImpl.getPermissions((AbstractItem)this.job);
    }

    public BluePipelineScm getScm() {
        return null;
    }

    public static Map<String, Boolean> getPermissions(AbstractItem item) {
        return ImmutableMap.of((Object)"create", (Object)item.getACL().hasPermission(Item.CREATE), (Object)"configure", (Object)item.getACL().hasPermission(Item.CONFIGURE), (Object)"read", (Object)item.getACL().hasPermission(Item.READ), (Object)"start", (Object)item.getACL().hasPermission(Item.BUILD), (Object)"stop", (Object)item.getACL().hasPermission(Item.CANCEL));
    }

    public boolean isFavorite() {
        User user = User.current();
        return user != null && Favorites.isFavorite((User)user, (Item)this.job);
    }

    @Extension(ordinal=0.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public BluePipeline getPipeline(Item item, Reachable parent) {
            if (item instanceof Job) {
                return new AbstractPipelineImpl((Job)item);
            }
            return null;
        }

        public Resource resolve(Item context, Reachable parent, Item target) {
            if (context == target && target instanceof Job) {
                return this.getPipeline(target, parent);
            }
            return null;
        }
    }
}

