/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.util;

import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.plugins.favorite.FavoritePlugin;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.service.embedded.rest.BlueFavoriteResolver;
import io.jenkins.blueocean.service.embedded.rest.BluePipelineFactory;
import io.jenkins.blueocean.service.embedded.rest.FavoriteImpl;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;

public class FavoriteUtil {
    public static void favoriteJob(String fullName, boolean favorite) {
        FavoritePlugin plugin;
        User user = User.current();
        if (user == null) {
            throw new ServiceException.ForbiddenException("Must be logged in to use set favorites");
        }
        boolean set = false;
        FavoriteUserProperty fup = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
        if (fup != null) {
            set = fup.isJobFavorite(fullName);
        }
        if ((plugin = (FavoritePlugin)Jenkins.getInstance().getPlugin(FavoritePlugin.class)) == null) {
            throw new ServiceException.UnexpectedErrorException("Can not find instance of Favorite Plugin");
        }
        if (favorite != set) {
            try {
                plugin.doToggleFavorite(Stapler.getCurrentRequest(), Stapler.getCurrentResponse(), fullName, Jenkins.getAuthentication().getName(), Boolean.valueOf(false));
            }
            catch (IOException e) {
                throw new ServiceException.UnexpectedErrorException("Something went wrong setting the favorite", (Throwable)e);
            }
        }
    }

    public static String decodeFullName(String name) {
        try {
            return URLDecoder.decode(URLDecoder.decode(name, "UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceException.UnexpectedErrorException("Something went wrong URL decoding fullName: " + name, (Throwable)e);
        }
    }

    public static BlueFavorite getFavorite(String fullName, Reachable parent) {
        TopLevelItem item = Jenkins.getInstance().getItem(fullName);
        return FavoriteUtil.getFavorite((Item)item, parent);
    }

    public static BlueFavorite getFavorite(Item item) {
        final Link l = LinkResolver.resolveLink((Object)item);
        if (l != null) {
            return FavoriteUtil.getFavorite(item, new Reachable(){

                public Link getLink() {
                    return l.ancestor();
                }
            });
        }
        return null;
    }

    public static BlueFavorite getFavorite(Item item, @Nonnull Reachable parent) {
        if (item == null) {
            return null;
        }
        for (BlueFavoriteResolver resolver : BlueFavoriteResolver.all()) {
            BlueFavorite blueFavorite = resolver.resolve(item, parent);
            if (blueFavorite == null) continue;
            return blueFavorite;
        }
        BluePipeline pipeline = BluePipelineFactory.getPipelineInstance(item, parent);
        if (pipeline != null) {
            return new FavoriteImpl(pipeline, pipeline.getLink().rel("favorite"));
        }
        return null;
    }
}

