/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.User;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import hudson.tasks.Mailer;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.service.embedded.rest.FavoriteContainerImpl;
import java.util.Collections;
import java.util.Map;
import jenkins.model.Jenkins;

public class UserImpl
extends BlueUser {
    private final User user;
    private final Reachable parent;

    public UserImpl(User user, Reachable parent) {
        this.parent = parent;
        this.user = user;
    }

    public UserImpl(User user) {
        this.user = user;
        this.parent = null;
    }

    public String getId() {
        return this.user.getId();
    }

    public String getFullName() {
        return this.user.getFullName();
    }

    public String getEmail() {
        String name = Jenkins.getAuthentication().getName();
        if (name.equals("anonymous") || this.user.getId().equals("anonymous")) {
            return null;
        }
        User user = User.get((String)name, (boolean)false, (Map)Collections.EMPTY_MAP);
        if (user == null) {
            return null;
        }
        if (!user.hasPermission(Jenkins.ADMINISTER)) {
            return null;
        }
        Mailer.UserProperty p = (Mailer.UserProperty)this.user.getProperty(Mailer.UserProperty.class);
        return p != null ? p.getAddress() : null;
    }

    protected boolean isFavorite(String name) {
        FavoriteUserProperty prop = (FavoriteUserProperty)this.user.getProperty(FavoriteUserProperty.class);
        return prop != null && prop.isJobFavorite(name);
    }

    protected FavoriteUserProperty getFavoriteProperty() {
        return (FavoriteUserProperty)this.user.getProperty(FavoriteUserProperty.class);
    }

    public BlueFavoriteContainer getFavorites() {
        String name = Jenkins.getAuthentication().getName();
        if (!this.user.getId().equals(name)) {
            throw new ServiceException.ForbiddenException("You do not have access to this resource.");
        }
        return new FavoriteContainerImpl(this, (Reachable)this);
    }

    public Link getLink() {
        return this.parent != null ? this.parent.getLink().rel(this.getId()) : ApiHead.INSTANCE().getLink().rel("users/" + this.getId());
    }
}

