/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.collect.ImmutableList;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TopLevelItem;
import hudson.util.RunList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.OmniSearch;
import io.jenkins.blueocean.rest.Query;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.pageable.Pageable;
import io.jenkins.blueocean.rest.pageable.Pageables;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import jenkins.model.Jenkins;

@Extension
public class RunSearch
extends OmniSearch<BlueRun> {
    public String getType() {
        return "run";
    }

    public Pageable<BlueRun> search(Query q) {
        String pipeline = q.param("pipeline", false);
        boolean latestOnly = (Boolean)q.param("latestOnly", Boolean.class);
        if (pipeline != null) {
            TopLevelItem p = Jenkins.getActiveInstance().getItem(pipeline);
            if (latestOnly) {
                BlueRun r = this.getLatestRun((Job)p);
                if (r != null) {
                    return Pageables.wrap(Collections.singletonList(r));
                }
                Pageables.empty();
            }
            if (p instanceof Job) {
                return Pageables.wrap(RunSearch.findRuns((Job)p));
            }
            throw new ServiceException.BadRequestExpception(String.format("Pipeline %s not found", pipeline));
        }
        if (latestOnly) {
            return Pageables.empty();
        }
        return Pageables.wrap(RunSearch.findRuns(null));
    }

    public static Iterable<BlueRun> findRuns(Job job, final Link parent) {
        ArrayList<BlueRun> runs = new ArrayList<BlueRun>();
        Object pipelines = job != null ? ImmutableList.of((Object)job) : Jenkins.getActiveInstance().getItems(Job.class);
        Iterator iterator = pipelines.iterator();
        while (iterator.hasNext()) {
            Job p = (Job)iterator.next();
            RunList runList = p.getBuilds();
            for (Run r : runList) {
                runs.add(AbstractRunImpl.getBlueRun(r, new Reachable(){

                    public Link getLink() {
                        return parent;
                    }
                }));
            }
        }
        return runs;
    }

    public static Iterable<BlueRun> findRuns(Job pipeline) {
        return RunSearch.findRuns(pipeline, null);
    }

    private BlueRun getLatestRun(Job job) {
        Run r;
        if (job != null && (r = job.getLastBuild()) != null) {
            AbstractRunImpl.getBlueRun(r, (Reachable)new PipelineContainerImpl().get(job.getFullName()));
        }
        return null;
    }
}

