/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.collect.Lists;
import hudson.model.BuildableItem;
import hudson.model.Job;
import hudson.model.Queue;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.hal.LinkResolver;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueItemImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;

public class QueueContainerImpl
extends BlueQueueContainer {
    private AbstractPipelineImpl pipeline;
    private Job job;

    public QueueContainerImpl(AbstractPipelineImpl pipeline) {
        this.pipeline = pipeline;
        this.job = pipeline.getJob();
    }

    public BlueQueueItem get(String name) {
        for (BlueQueueItem blueQueueItem : QueueContainerImpl.getQueuedItems(this.job)) {
            if (!name.equals(blueQueueItem.getId())) continue;
            return blueQueueItem;
        }
        return null;
    }

    public Iterator<BlueQueueItem> iterator() {
        return QueueContainerImpl.getQueuedItems(this.job).iterator();
    }

    public static List<BlueQueueItem> getQueuedItems(Job job) {
        Link pipelineLink = LinkResolver.resolveLink((Object)job);
        if (job instanceof BuildableItem) {
            BuildableItem task = (BuildableItem)job;
            List items = Jenkins.getInstance().getQueue().getItems((Queue.Task)task);
            ArrayList items2 = Lists.newArrayList();
            for (int i = 0; i < items.size(); ++i) {
                Link self = pipelineLink.rel("queue").rel(Long.toString(((Queue.Item)items.get(i)).getId()));
                items2.add(0, new QueueItemImpl((Queue.Item)items.get(i), job.getName(), items.size() == 1 ? job.getNextBuildNumber() : job.getNextBuildNumber() + i, self));
            }
            return items2;
        }
        throw new ServiceException.UnexpectedErrorException("This pipeline is not buildable and therefore does not have a queue.");
    }

    public static BlueQueueItem getQueuedItem(Queue.Item item, Job job) {
        for (BlueQueueItem qi : QueueContainerImpl.getQueuedItems(job)) {
            if (!qi.getId().equalsIgnoreCase(Long.toString(item.getId()))) continue;
            return qi;
        }
        return null;
    }

    public Link getLink() {
        return this.pipeline.getLink().rel("queue");
    }
}

