/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.service.embedded.rest.BluePipelineFactory;
import io.jenkins.blueocean.service.embedded.rest.ContainerFilter;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public class PipelineContainerImpl
extends BluePipelineContainer {
    @Nonnull
    private final ItemGroup itemGroup;
    private final Link self;

    public PipelineContainerImpl() {
        this((ItemGroup)Jenkins.getInstance(), null);
    }

    public PipelineContainerImpl(ItemGroup itemGroup) {
        this(itemGroup, null);
    }

    public PipelineContainerImpl(ItemGroup itemGroup, Reachable parent) {
        this.itemGroup = itemGroup;
        this.self = parent != null ? parent.getLink().rel("pipelines") : OrganizationImpl.INSTANCE.getLink().rel("pipelines");
    }

    public Link getLink() {
        return this.self;
    }

    public BluePipeline get(String name) {
        Item item = this.itemGroup.getItem(name);
        if (item == null) {
            throw new ServiceException.NotFoundException(String.format("Pipeline %s not found", name));
        }
        return BluePipelineFactory.getPipelineInstance(item, (Reachable)this);
    }

    public Iterator<BluePipeline> iterator() {
        return this.getPipelines(this.itemGroup.getItems());
    }

    public Iterator<BluePipeline> getPipelines(Collection<? extends Item> items) {
        items = ContainerFilter.filter(items);
        ArrayList<BluePipeline> pipelines = new ArrayList<BluePipeline>();
        for (Item item : items) {
            BluePipeline pipeline = BluePipelineFactory.getPipelineInstance(item, (Reachable)this);
            if (pipeline == null) continue;
            pipelines.add(pipeline);
        }
        return pipelines.iterator();
    }
}

