/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.ItemGroup;
import hudson.model.User;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.JsonBody;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BlueUser;
import io.jenkins.blueocean.rest.model.BlueUserContainer;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.UserContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import java.io.IOException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.DELETE;
import org.kohsuke.stapler.verb.PUT;

public class OrganizationImpl
extends BlueOrganization {
    private final UserContainerImpl users = new UserContainerImpl((Reachable)this);
    public static final OrganizationImpl INSTANCE = new OrganizationImpl();

    private OrganizationImpl() {
    }

    public String getName() {
        return Jenkins.getInstance().getDisplayName().toLowerCase();
    }

    public BluePipelineContainer getPipelines() {
        return new PipelineContainerImpl((ItemGroup)Jenkins.getInstance());
    }

    @WebMethod(name={""})
    @DELETE
    public void delete() {
        throw new ServiceException.NotImplementedException("Not implemented yet");
    }

    @WebMethod(name={""})
    @PUT
    public void update(@JsonBody OrganizationImpl given) throws IOException {
        given.validate();
        throw new ServiceException.NotImplementedException("Not implemented yet");
    }

    private void validate() {
    }

    public BlueUserContainer getUsers() {
        return this.users;
    }

    public BlueUser getUser() {
        User user = User.current();
        if (user == null) {
            throw new ServiceException.NotFoundException("No authenticated user found");
        }
        return new UserImpl(user, (Reachable)new UserContainerImpl((Reachable)INSTANCE));
    }

    public Link getLink() {
        return ApiHead.INSTANCE().getLink().rel("organizations/" + this.getName());
    }
}

