/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.console.AnnotatedLargeText;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import org.kohsuke.stapler.AcceptHeader;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.framework.io.CharSpool;
import org.kohsuke.stapler.framework.io.LineEndNormalizingWriter;

public class LogResource {
    public static final long DEFAULT_LOG_THREASHOLD = 150L;
    private final AnnotatedLargeText logText;

    public LogResource(AnnotatedLargeText log) {
        this.logText = log;
    }

    public void doIndex(StaplerRequest req, StaplerResponse rsp, @Header(value="Accept") AcceptHeader accept) {
        this.writeLog(req, rsp, accept);
    }

    private void writeLog(StaplerRequest req, StaplerResponse rsp, AcceptHeader accept) {
        try {
            String download = req.getParameter("download");
            if ("true".equalsIgnoreCase(download)) {
                rsp.setHeader("Content-Disposition", "attachment; filename=log.txt");
            }
            switch (accept.select(new String[]{"text/plain", "text/html"})) {
                case "text/html": {
                    rsp.setContentType("text/html;charset=UTF-8");
                    rsp.setStatus(200);
                    req.setAttribute("html", (Object)true);
                    break;
                }
                case "text/plain": {
                    rsp.setContentType("text/plain;charset=UTF-8");
                    rsp.setStatus(200);
                }
            }
            this.writeLogs(req, rsp);
        }
        catch (IOException e) {
            throw new ServiceException.UnexpectedErrorException("Failed to get logText: " + e.getMessage(), (Throwable)e);
        }
    }

    private void writeLogs(StaplerRequest req, StaplerResponse rsp) throws IOException {
        long threshold = 153600L;
        String s = req.getParameter("thresholdInKB");
        if (s != null) {
            threshold = Long.parseLong(s) * 1024L;
        }
        long offset = req.getParameter("start") != null ? Long.parseLong(req.getParameter("start")) : (this.logText.length() > threshold ? this.logText.length() - threshold : 0L);
        CharSpool spool = new CharSpool();
        long r = this.logText.writeLogTo(offset, (Writer)spool);
        rsp.addHeader("X-Text-Size", String.valueOf(r));
        if (!this.logText.isComplete()) {
            rsp.addHeader("X-More-Data", "true");
        }
        Writer w = this.createWriter(req, rsp, r - offset);
        spool.writeTo((Writer)new LineEndNormalizingWriter(w));
        w.close();
    }

    private Writer createWriter(StaplerRequest req, StaplerResponse rsp, long size) throws IOException {
        if (size > 4096L) {
            return rsp.getCompressedWriter((HttpServletRequest)req);
        }
        return rsp.getWriter();
    }
}

