/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueExtensionClass;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExtensionClassImpl
extends BlueExtensionClass {
    private final Class baseClass;
    private final Reachable parent;
    private static final String[] BLACK_LISTED_CLASSES = new String[]{"java.", "javax.", "com.sun."};

    public ExtensionClassImpl(Class baseClass, Reachable parent) {
        this.baseClass = baseClass;
        this.parent = parent;
    }

    public Collection<String> getClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        this.collectSuperClasses(classes, this.baseClass);
        return classes;
    }

    private void collectSuperClasses(List<String> classes, Class base) {
        this.captureCapabilityAnnotation(classes, base);
        Class clz = base.getSuperclass();
        if (clz != null && !this.isBlackListed(clz.getName()) && !classes.contains(clz.getName())) {
            classes.add(clz.getName());
            this.captureCapabilityAnnotation(classes, clz);
            this.collectSuperClasses(classes, clz);
        }
    }

    private void captureCapabilityAnnotation(List<String> classes, Class clz) {
        Capability annotation = clz.getAnnotation(Capability.class);
        if (annotation != null) {
            Capability capability = annotation;
            for (String c : capability.value()) {
                if (classes.contains(c)) continue;
                classes.add(c);
            }
        }
    }

    private boolean isBlackListed(String clz) {
        for (String s : BLACK_LISTED_CLASSES) {
            if (!clz.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public Link getLink() {
        return this.parent.getLink().rel(this.baseClass.getName());
    }
}

