/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.commons.stapler.JsonBody;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueExtensionClass;
import io.jenkins.blueocean.rest.model.BlueExtensionClassContainer;
import io.jenkins.blueocean.rest.model.BlueExtensionClassMap;
import io.jenkins.blueocean.service.embedded.rest.ExtensionClassImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class ExtensionClassContainerImpl
extends BlueExtensionClassContainer {
    public BlueExtensionClass get(String name) {
        return new ExtensionClassImpl(ExtensionClassContainerImpl.getClazz(name), (Reachable)this);
    }

    public BlueExtensionClassMap getMap(@QueryParameter(value="q") String param) {
        if (param == null || param.trim().isEmpty()) {
            return new BlueExtensionClassMap(){

                public Link getLink() {
                    return ExtensionClassContainerImpl.this.getLink();
                }

                public Map<String, BlueExtensionClass> getMap() {
                    return Collections.EMPTY_MAP;
                }
            };
        }
        ArrayList<String> classList = new ArrayList<String>();
        for (String p : param.split(",")) {
            p = p.trim();
            classList.add(p.trim());
        }
        return new BlueExtensionClassMapImpl(classList, this.getLink().rel("?q=" + param));
    }

    public BlueExtensionClassMap getMap(@JsonBody Map<String, List<String>> request) {
        List<String> cl = request.get("q") != null ? request.get("q") : Collections.emptyList();
        return new BlueExtensionClassMapImpl(cl, this.getLink());
    }

    public Link getLink() {
        return ApiHead.INSTANCE().getLink().rel(this.getUrlName());
    }

    private static Class getClazz(String name) {
        try {
            return Jenkins.getInstance().getPluginManager().uberClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException.NotFoundException(String.format("Class %s is not known", name));
        }
    }

    public static class BlueExtensionClassMapImpl
    extends BlueExtensionClassMap {
        private final Map<String, BlueExtensionClass> classMap = new HashMap<String, BlueExtensionClass>();
        private final Link self;

        public BlueExtensionClassMapImpl(List<String> classList, Link self) {
            for (String c : classList) {
                this.classMap.put(c, new ExtensionClassImpl(ExtensionClassContainerImpl.getClazz(c), (Reachable)this));
            }
            this.self = self;
        }

        public Link getLink() {
            return this.self;
        }

        public Map<String, BlueExtensionClass> getMap() {
            return this.classMap;
        }
    }
}

