/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import java.util.Collection;
import java.util.LinkedList;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;

public abstract class ContainerFilter
implements ExtensionPoint {
    public abstract String getName();

    public abstract Predicate<Item> getFilter();

    public static <T extends Item> Collection<T> filter(Collection<T> items) {
        StaplerRequest req = Stapler.getCurrentRequest();
        if (req == null) {
            return items;
        }
        String itemFilter = req.getParameter("filter");
        if (itemFilter == null) {
            return items;
        }
        return ContainerFilter.filter(items, itemFilter.split(","));
    }

    public static <T extends Item> Collection<T> filter(Collection<T> items, String ... filterNames) {
        if (filterNames != null && filterNames.length > 0) {
            Predicate[] filters = new Predicate[filterNames.length];
            for (int i = 0; i < filterNames.length; ++i) {
                Predicate<Item> f = ContainerFilter.getItemFilter(filterNames[i]);
                if (f == null) {
                    throw new IllegalArgumentException("Invalid filter type specified.");
                }
                filters[i] = f;
            }
            LinkedList<Item> out = new LinkedList<Item>();
            block1: for (Item item : items) {
                for (int i = 0; i < filters.length; ++i) {
                    if (!filters[i].apply((Object)item)) continue block1;
                }
                out.add(item);
            }
            return out;
        }
        return items;
    }

    public static Predicate<Item> getItemFilter(String filterName) {
        for (ContainerFilter itemFilter : ExtensionList.lookup(ContainerFilter.class)) {
            if (!itemFilter.getName().equals(filterName)) continue;
            return itemFilter.getFilter();
        }
        return null;
    }
}

