/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import hudson.util.RunList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ActionProxiesImpl;
import io.jenkins.blueocean.service.embedded.rest.BluePipelineFactory;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.RunContainerImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.json.JsonBody;
import org.kohsuke.stapler.verb.DELETE;

@Capability(value={"hudson.model.Job"})
public class AbstractPipelineImpl
extends BluePipeline {
    private final Job job;
    public static final Predicate<Run> isRunning = new Predicate<Run>(){

        public boolean apply(Run r) {
            return r.isBuilding();
        }
    };

    protected AbstractPipelineImpl(Job job) {
        this.job = job;
    }

    public String getOrganization() {
        return OrganizationImpl.INSTANCE.getName();
    }

    public String getName() {
        return this.job.getName();
    }

    public String getDisplayName() {
        return this.job.getDisplayName();
    }

    public Integer getWeatherScore() {
        return this.job.getBuildHealth().getScore();
    }

    public BlueRun getLatestRun() {
        if (this.job.getLastBuild() == null) {
            return null;
        }
        return AbstractRunImpl.getBlueRun(this.job.getLastBuild(), (Reachable)this);
    }

    public Long getEstimatedDurationInMillis() {
        return this.job.getEstimatedDuration();
    }

    public String getLastSuccessfulRun() {
        if (this.job.getLastSuccessfulBuild() != null) {
            String id = this.job.getLastSuccessfulBuild().getId();
            return Stapler.getCurrentRequest().getRootPath() + this.getLink().getHref() + "runs/" + id + "/";
        }
        return null;
    }

    public BlueRunContainer getRuns() {
        return new RunContainerImpl(this, this.job);
    }

    public Collection<BlueActionProxy> getActions() {
        return AbstractPipelineImpl.getActionProxies(this.job.getAllActions(), (Reachable)this);
    }

    @Navigable
    public BlueQueueContainer getQueue() {
        return new QueueContainerImpl(this);
    }

    @WebMethod(name={""})
    @DELETE
    public void delete() throws IOException, InterruptedException {
        this.job.delete();
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestExpception("Must provide pipeline name");
        }
        FavoriteUtil.favoriteJob(this.job.getFullName(), favoriteAction.isFavorite());
        return FavoriteUtil.getFavorite((Item)this.job, new Reachable(){

            public Link getLink() {
                return AbstractPipelineImpl.this.getLink().ancestor();
            }
        });
    }

    public String getFullName() {
        return this.job.getFullName();
    }

    public Link getLink() {
        return OrganizationImpl.INSTANCE.getLink().rel("pipelines").rel(AbstractPipelineImpl.getRecursivePathFromFullName(this));
    }

    public static String getRecursivePathFromFullName(BluePipeline pipeline) {
        StringBuilder pipelinePath = new StringBuilder();
        String[] names = pipeline.getFullName().split("/");
        int count = 1;
        if (names.length > 1) {
            for (String n : names) {
                if (count == 1) {
                    pipelinePath.append(n);
                } else {
                    pipelinePath.append("/pipelines/").append(n);
                }
                ++count;
            }
        } else {
            pipelinePath.append(pipeline.getFullName());
        }
        return pipelinePath.toString();
    }

    public static Collection<BlueActionProxy> getActionProxies(List<? extends Action> actions, Reachable parent) {
        ArrayList<BlueActionProxy> actionProxies = new ArrayList<BlueActionProxy>();
        for (Action action : actions) {
            if (action == null) continue;
            actionProxies.add(new ActionProxiesImpl(action, parent));
        }
        return actionProxies;
    }

    @Navigable
    public Container<Resource> getActivities() {
        return Containers.fromResource((Link)this.getLink(), (List)Lists.newArrayList((Iterator)Iterators.concat((Iterator)this.getQueue().iterator(), (Iterator)this.getRuns().iterator())));
    }

    public Job getJob() {
        return this.job;
    }

    public int getNumberOfRunningPipelines() {
        RunList runningJobs = this.job.getBuilds().filter(isRunning);
        return Iterators.size((Iterator)runningJobs.iterator());
    }

    public int getNumberOfQueuedPipelines() {
        if (this.job instanceof BuildableItem) {
            return Iterables.size((Iterable)Jenkins.getInstance().getQueue().getItems((Queue.Task)((BuildableItem)this.job)));
        }
        return 0;
    }

    public Map<String, Boolean> getPermissions() {
        return AbstractPipelineImpl.getPermissions((AbstractItem)this.job);
    }

    public static Map<String, Boolean> getPermissions(AbstractItem item) {
        return ImmutableMap.of((Object)"create", (Object)item.getACL().hasPermission(Item.CREATE), (Object)"read", (Object)item.getACL().hasPermission(Item.READ), (Object)"start", (Object)item.getACL().hasPermission(Item.BUILD), (Object)"stop", (Object)item.getACL().hasPermission(Item.CANCEL));
    }

    public boolean isFavorite() {
        User user = User.current();
        if (user != null) {
            FavoriteUserProperty prop = (FavoriteUserProperty)user.getProperty(FavoriteUserProperty.class);
            return prop != null && prop.isJobFavorite(this.job.getFullName());
        }
        return false;
    }

    @Extension(ordinal=0.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        @Override
        public BluePipeline getPipeline(Item item, Reachable parent) {
            if (item instanceof Job) {
                return new AbstractPipelineImpl((Job)item);
            }
            return null;
        }

        @Override
        public Resource resolve(Item context, Reachable parent, Item target) {
            if (context == target && target instanceof Job) {
                return this.getPipeline(target, parent);
            }
            return null;
        }
    }
}

