/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.remoting.Base64;
import io.jenkins.blueocean.BlueOceanUI;
import io.jenkins.blueocean.commons.BlueOceanConfigProperties;
import io.jenkins.blueocean.service.embedded.JwtAuthenticationToken;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.context.SecurityContextImpl;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class BlueOceanRootAction
implements UnprotectedRootAction,
StaplerProxy {
    private static final String URL_BASE = "blue";
    private static final Long randomBits = new Random().nextLong();
    private final boolean enableJWT = BlueOceanConfigProperties.BLUEOCEAN_FEATURE_JWT_AUTHENTICATION;
    @Inject
    private BlueOceanUI app;

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return URL_BASE;
    }

    public Object getTarget() {
        StaplerRequest request = Stapler.getCurrentRequest();
        if (request.getOriginalRestOfPath().startsWith("/rest/")) {
            if (this.enableJWT) {
                Authentication tokenAuthentication = JwtAuthenticationToken.create(request);
                SecurityContextImpl securityContext = new SecurityContextImpl();
                securityContext.setAuthentication(tokenAuthentication);
                SecurityContextHolder.setContext((SecurityContext)securityContext);
            } else {
                HashCode hashCode = Hashing.sha1().newHasher().putString((CharSequence)Jenkins.getAuthentication().getName(), StandardCharsets.UTF_8).putLong(randomBits.longValue()).hash();
                String refresherToken = Base64.encode((byte[])hashCode.asBytes());
                Stapler.getCurrentResponse().setHeader("X-Blueocean-Refresher", refresherToken);
            }
        } else {
            Jenkins.getInstance().checkPermission(Jenkins.READ);
        }
        return this.app;
    }

    @Extension
    public static class ModuleImpl
    implements Module {
        public void configure(Binder binder) {
            binder.bind(BlueOceanUI.class).toInstance((Object)new BlueOceanUI(BlueOceanRootAction.URL_BASE));
        }
    }
}

