/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.jsextensions;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.PluginWrapper;
import hudson.util.HttpResponses;
import io.jenkins.blueocean.RootRoutable;
import io.jenkins.blueocean.rest.model.BlueExtensionClass;
import io.jenkins.blueocean.rest.model.BlueExtensionClassContainer;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.WebMethod;
import org.kohsuke.stapler.verb.GET;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
@Restricted(value={NoExternalUse.class})
public class JenkinsJSExtensions
implements RootRoutable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JenkinsJSExtensions.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final List<PluginWrapper> pluginCache = new CopyOnWriteArrayList<PluginWrapper>();
    private static final Map<String, Object> jsExtensionCache = new ConcurrentHashMap<String, Object>();

    public String getUrlName() {
        return "js-extensions";
    }

    @WebMethod(name={""})
    @GET
    public HttpResponse doData() {
        Collection<Object> jsExtensionData = JenkinsJSExtensions.getJenkinsJSExtensionData();
        JSONArray jsExtensionDataJson = JSONArray.fromObject(jsExtensionData);
        return HttpResponses.okJSON((JSONArray)jsExtensionDataJson);
    }

    static Collection<Object> getJenkinsJSExtensionData() {
        JenkinsJSExtensions.refreshCacheIfNeeded();
        return jsExtensionCache.values();
    }

    private static String getGav(Map ext) {
        return ext.get("hpiPluginId") != null ? (String)ext.get("hpiPluginId") : null;
    }

    private static void refreshCacheIfNeeded() {
        List latestPlugins = Jenkins.getInstance().getPluginManager().getPlugins();
        if (!latestPlugins.equals(pluginCache)) {
            JenkinsJSExtensions.refreshCache(latestPlugins);
        }
    }

    private static synchronized void refreshCache(List<PluginWrapper> latestPlugins) {
        if (!latestPlugins.equals(pluginCache)) {
            pluginCache.clear();
            pluginCache.addAll(latestPlugins);
            JenkinsJSExtensions.refreshCache(pluginCache);
        }
        for (PluginWrapper pluginWrapper : pluginCache) {
            if (jsExtensionCache.get(pluginWrapper.getLongName()) != null) continue;
            try {
                Enumeration<URL> dataResources = pluginWrapper.classLoader.getResources("jenkins-js-extension.json");
                while (dataResources.hasMoreElements()) {
                    URL dataRes = dataResources.nextElement();
                    StringWriter fileContentBuffer = new StringWriter();
                    LOGGER.debug("Reading 'jenkins-js-extension.json' from '{}'.", (Object)dataRes);
                    try {
                        IOUtils.copy((InputStream)dataRes.openStream(), (Writer)fileContentBuffer, (Charset)Charset.forName("UTF-8"));
                        Map extensionData = (Map)mapper.readValue(dataRes.openStream(), Map.class);
                        List extensions = (List)extensionData.get("extensions");
                        for (Map extension : extensions) {
                            try {
                                String type = (String)extension.get("type");
                                if (type == null) continue;
                                BlueExtensionClassContainer extensionClassContainer = (BlueExtensionClassContainer)Jenkins.getInstance().getExtensionList(BlueExtensionClassContainer.class).get(0);
                                Map classInfo = (Map)JenkinsJSExtensions.mergeObjects(extensionClassContainer.get(type));
                                List classInfoClasses = (List)classInfo.get("_classes");
                                classInfoClasses.add(0, type);
                                extension.put("_class", type);
                                extension.put("_classes", classInfoClasses);
                            }
                            catch (Exception e) {
                                LOGGER.error("An error occurred when attempting to read type information from jenkins-js-extension.json from: " + dataRes, (Throwable)e);
                            }
                        }
                        String pluginId = JenkinsJSExtensions.getGav(extensionData);
                        if (pluginId != null) {
                            jsExtensionCache.put(pluginId, JenkinsJSExtensions.mergeObjects(extensionData));
                            continue;
                        }
                        LOGGER.error(String.format("Plugin %s JS extension has missing hpiPluginId", pluginWrapper.getLongName()));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error reading 'jenkins-js-extension.json' from '" + dataRes + "'. Extensions defined in the host plugin will not be active.", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error(String.format("Error locating jenkins-js-extension.json for plugin %s", pluginWrapper.getLongName()));
            }
        }
    }

    private static Object mergeObjects(Object incoming) {
        if (incoming instanceof Map) {
            HashMap m = new HashMap();
            Map in = (Map)incoming;
            for (Object key : in.keySet()) {
                Object value = JenkinsJSExtensions.mergeObjects(in.get(key));
                m.put(key, value);
            }
            return m;
        }
        if (incoming instanceof Collection) {
            ArrayList l = new ArrayList();
            for (Object i : (Collection)incoming) {
                i = JenkinsJSExtensions.mergeObjects(i);
                l.add(i);
            }
            return l;
        }
        if (incoming instanceof Class) {
            return ((Class)incoming).getName();
        }
        if (incoming instanceof BlueExtensionClass) {
            BlueExtensionClass in = (BlueExtensionClass)incoming;
            HashMap<String, Object> m = new HashMap<String, Object>();
            Object value = JenkinsJSExtensions.mergeObjects(in.getClasses());
            m.put("_classes", value);
            return m;
        }
        return incoming;
    }
}

