/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.ScheduleResult;
import hudson.util.RunList;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.BlueRunContainer;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.QueueContainerImpl;
import io.jenkins.blueocean.service.embedded.rest.RunSearch;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public class RunContainerImpl
extends BlueRunContainer {
    private final Job job;
    private final BluePipeline pipeline;

    public RunContainerImpl(@Nonnull BluePipeline pipeline, @Nonnull Job job) {
        this.job = job;
        this.pipeline = pipeline;
    }

    public Link getLink() {
        return this.pipeline.getLink().rel("runs");
    }

    public BlueRun get(String name) {
        RunList runList = this.job.getBuilds();
        Run run = null;
        if (name != null) {
            for (Run r : runList) {
                if (!r.getId().equals(name)) continue;
                run = r;
                break;
            }
            if (run == null) {
                throw new ServiceException.NotFoundException(String.format("Run %s not found in organization %s and pipeline %s", name, this.pipeline.getOrganization(), this.job.getName()));
            }
        } else {
            run = runList.getLastBuild();
        }
        return AbstractRunImpl.getBlueRun(run, (Reachable)this.pipeline);
    }

    public Iterator<BlueRun> iterator() {
        return RunSearch.findRuns(this.job, this.pipeline.getLink()).iterator();
    }

    public BluePipeline getPipeline(String name) {
        return this.pipeline;
    }

    public BlueQueueItem create() {
        this.job.checkPermission(Item.BUILD);
        if (this.job instanceof Queue.Task) {
            ScheduleResult scheduleResult = Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.job, 0, new Action[]{new CauseAction((Cause)new Cause.UserIdCause())});
            if (scheduleResult.isAccepted()) {
                Queue.Item item = scheduleResult.getItem();
                BlueQueueItem queueItem = QueueContainerImpl.getQueuedItem(item, this.job);
                if (queueItem == null) {
                    throw new ServiceException.UnexpectedErrorException("The queue item does not exist in the queue");
                }
                return queueItem;
            }
            throw new ServiceException.UnexpectedErrorException("Queue item request was not accepted");
        }
        throw new ServiceException.NotImplementedException("This pipeline type does not support being queued.");
    }
}

