/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import com.google.common.collect.ImmutableMap;
import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteAction;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BluePipelineContainer;
import io.jenkins.blueocean.rest.model.BluePipelineFolder;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.BluePipelineFactory;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import io.jenkins.blueocean.service.embedded.rest.PipelineContainerImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.kohsuke.stapler.json.JsonBody;

public class PipelineFolderImpl
extends BluePipelineFolder {
    private final ItemGroup folder;
    private final Link parent;

    public PipelineFolderImpl(ItemGroup folder, Link parent) {
        this.folder = folder;
        this.parent = parent;
    }

    public String getOrganization() {
        return OrganizationImpl.INSTANCE.getName();
    }

    public String getName() {
        return this.folder.getDisplayName();
    }

    public String getDisplayName() {
        return this.folder.getDisplayName();
    }

    public String getFullName() {
        return this.folder.getFullName();
    }

    public Collection<BlueActionProxy> getActions() {
        return Collections.emptyList();
    }

    public BluePipelineContainer getPipelines() {
        return new PipelineContainerImpl(this.folder, (Reachable)this);
    }

    public Integer getNumberOfFolders() {
        int count = 0;
        for (BluePipeline p : this.getPipelines()) {
            if (!(p instanceof BluePipelineFolder)) continue;
            ++count;
        }
        return count;
    }

    public Integer getNumberOfPipelines() {
        int count = 0;
        for (BluePipeline p : this.getPipelines()) {
            if (p instanceof BluePipelineFolder) continue;
            ++count;
        }
        return count;
    }

    public BlueFavorite favorite(@JsonBody BlueFavoriteAction favoriteAction) {
        if (favoriteAction == null) {
            throw new ServiceException.BadRequestExpception("Must provide pipeline name");
        }
        FavoriteUtil.favoriteJob(this.folder.getFullName(), favoriteAction.isFavorite());
        return FavoriteUtil.getFavorite(this.folder.getFullName(), (Reachable)this);
    }

    public Map<String, Boolean> getPermissions() {
        if (this.folder instanceof AbstractItem) {
            AbstractItem item = (AbstractItem)this.folder;
            return ImmutableMap.of((Object)"create", (Object)item.getACL().hasPermission(Item.CREATE), (Object)"read", (Object)item.getACL().hasPermission(Item.READ));
        }
        return null;
    }

    public int getNumberOfRunningPipelines() {
        return 0;
    }

    public int getNumberOfQueuedPipelines() {
        return 0;
    }

    public Link getLink() {
        return OrganizationImpl.INSTANCE.getLink().rel("pipelines").rel(AbstractPipelineImpl.getRecursivePathFromFullName((BluePipeline)this));
    }

    @Extension(ordinal=0.0)
    public static class PipelineFactoryImpl
    extends BluePipelineFactory {
        public PipelineFolderImpl getPipeline(Item item, Reachable parent) {
            if (item instanceof ItemGroup) {
                return new PipelineFolderImpl((ItemGroup)item, parent.getLink());
            }
            return null;
        }

        @Override
        public Resource resolve(Item context, Reachable parent, Item target) {
            PipelineFolderImpl folder = this.getPipeline(context, parent);
            if (folder != null) {
                if (context == target) {
                    return folder;
                }
                Item nextChild = PipelineFactoryImpl.findNextStep(folder.folder, target);
                for (BluePipelineFactory f : PipelineFactoryImpl.all()) {
                    Resource answer = f.resolve(nextChild, (Reachable)folder, target);
                    if (answer == null) continue;
                    return answer;
                }
            }
            return null;
        }
    }
}

