/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BlueOrganizationContainer;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import java.util.Collections;
import java.util.Iterator;
import jenkins.model.Jenkins;

@Extension
public class OrganizationContainerImpl
extends BlueOrganizationContainer {
    public BlueOrganization get(String name) {
        this.validateOrganization(name);
        return OrganizationImpl.INSTANCE;
    }

    public Iterator<BlueOrganization> iterator() {
        return Collections.singleton(OrganizationImpl.INSTANCE).iterator();
    }

    protected void validateOrganization(String organization) {
        if (!organization.equals(Jenkins.getActiveInstance().getDisplayName().toLowerCase())) {
            throw new ServiceException.UnprocessableEntityException(String.format("Organization %s not found", organization));
        }
    }

    public Link getLink() {
        return ApiHead.INSTANCE().getLink().rel("organizations");
    }
}

