/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import hudson.model.FreeStyleBuild;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueRunFactory;
import io.jenkins.blueocean.service.embedded.rest.ChangeSetResource;
import io.jenkins.blueocean.service.embedded.rest.StoppableRun;
import java.util.LinkedHashMap;
import org.kohsuke.stapler.QueryParameter;

@Capability(value={"hudson.model.FreeStyleBuild"})
public class FreeStyleRunImpl
extends AbstractRunImpl<FreeStyleBuild> {
    public FreeStyleRunImpl(FreeStyleBuild run, Link parent) {
        super(run, parent);
    }

    @Override
    public Container<BlueChangeSetEntry> getChangeSet() {
        LinkedHashMap<String, ChangeSetResource> m = new LinkedHashMap<String, ChangeSetResource>();
        int cnt = 0;
        for (ChangeLogSet.Entry e : ((FreeStyleBuild)this.run).getChangeSet()) {
            ++cnt;
            String id = e.getCommitId();
            if (id == null) {
                id = String.valueOf(cnt);
            }
            m.put(id, new ChangeSetResource(e, (Reachable)this));
        }
        return Containers.fromResourceMap((Link)this.getLink(), m);
    }

    @Override
    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        return this.stop(blocking, timeOutInSecs, new StoppableRun(){

            @Override
            public void stop() throws Exception {
                ((FreeStyleBuild)FreeStyleRunImpl.this.run).doStop();
            }
        });
    }

    @Extension
    public static class FactoryImpl
    extends BlueRunFactory {
        @Override
        public BlueRun getRun(Run run, Reachable parent) {
            if (run instanceof FreeStyleBuild) {
                return new FreeStyleRunImpl((FreeStyleBuild)run, parent.getLink());
            }
            return null;
        }
    }
}

