/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Item;
import hudson.plugins.favorite.user.FavoriteUserProperty;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueFavorite;
import io.jenkins.blueocean.rest.model.BlueFavoriteContainer;
import io.jenkins.blueocean.service.embedded.rest.UserImpl;
import io.jenkins.blueocean.service.embedded.util.FavoriteUtil;
import java.util.ArrayList;
import java.util.Iterator;
import jenkins.model.Jenkins;

public class FavoriteContainerImpl
extends BlueFavoriteContainer {
    private final UserImpl user;
    private final Link self;

    public FavoriteContainerImpl(UserImpl user, Reachable parent) {
        this.user = user;
        this.self = parent.getLink().rel("favorites");
    }

    public BlueFavorite get(String name) {
        Item item;
        if (this.user.isFavorite(name = FavoriteUtil.decodeFullName(name)) && (item = Jenkins.getInstance().getItemByFullName(name)) != null) {
            return FavoriteUtil.getFavorite(item, (Reachable)this);
        }
        return null;
    }

    public Iterator<BlueFavorite> iterator() {
        FavoriteUserProperty prop = this.user.getFavoriteProperty();
        ArrayList<BlueFavorite> favorites = new ArrayList<BlueFavorite>();
        Jenkins j = Jenkins.getInstance();
        for (String favorite : prop.getFavorites()) {
            BlueFavorite blueFavorite;
            Item i = j.getItemByFullName(favorite, Item.class);
            if (i == null || (blueFavorite = FavoriteUtil.getFavorite(i)) == null) continue;
            favorites.add(blueFavorite);
        }
        return favorites.iterator();
    }

    public Link getLink() {
        return this.self;
    }
}

