/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.Extension;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.ApiHead;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueExtensionClass;
import io.jenkins.blueocean.rest.model.BlueExtensionClassContainer;
import io.jenkins.blueocean.rest.model.BlueExtensionClassMap;
import io.jenkins.blueocean.service.embedded.rest.ExtensionClassImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class ExtensionClassContainerImpl
extends BlueExtensionClassContainer {
    public BlueExtensionClass get(String name) {
        return new ExtensionClassImpl(this.getClazz(name), (Reachable)this);
    }

    public BlueExtensionClassMap getMap(final @QueryParameter(value="q") String param) {
        if (param == null || param.trim().isEmpty()) {
            return new BlueExtensionClassMap(){

                public Link getLink() {
                    return ExtensionClassContainerImpl.this.getLink();
                }

                public Map<String, BlueExtensionClass> getMap() {
                    return Collections.EMPTY_MAP;
                }
            };
        }
        final HashMap<String, ExtensionClassImpl> classMap = new HashMap<String, ExtensionClassImpl>();
        for (String p : param.split(",")) {
            p = p.trim();
            classMap.put(p, new ExtensionClassImpl(this.getClazz(p), (Reachable)this));
        }
        return new BlueExtensionClassMap(){

            public Link getLink() {
                return ExtensionClassContainerImpl.this.getLink().rel("?q=" + param);
            }

            public Map<String, BlueExtensionClass> getMap() {
                return classMap;
            }
        };
    }

    public Link getLink() {
        return ApiHead.INSTANCE().getLink().rel(this.getUrlName());
    }

    private Class getClazz(String name) {
        try {
            return Jenkins.getInstance().getPluginManager().uberClassLoader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ServiceException.NotFoundException(String.format("Class %s is not known", name));
        }
    }
}

