/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.Resource;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import jenkins.model.Jenkins;

public abstract class BluePipelineFactory
implements ExtensionPoint {
    public abstract BluePipeline getPipeline(Item var1, Reachable var2);

    public abstract Resource resolve(Item var1, Reachable var2, Item var3);

    public static ExtensionList<BluePipelineFactory> all() {
        return ExtensionList.lookup(BluePipelineFactory.class);
    }

    public static Resource resolve(Item item) {
        Item nextStep = BluePipelineFactory.findNextStep((ItemGroup)Jenkins.getInstance(), item);
        for (BluePipelineFactory f : BluePipelineFactory.all()) {
            Resource r = f.resolve(nextStep, (Reachable)OrganizationImpl.INSTANCE.getPipelines(), item);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    protected static Item findNextStep(ItemGroup context, Item target) {
        Item i = null;
        while (context != target) {
            i = target;
            if (!(target.getParent() instanceof Item)) break;
            target = (Item)target.getParent();
        }
        return i == null ? target : i;
    }

    public static BluePipeline getPipelineInstance(Item item, Reachable parent) {
        for (BluePipelineFactory factory : BluePipelineFactory.all()) {
            BluePipeline pipeline = factory.getPipeline(item, parent);
            if (pipeline == null) continue;
            return pipeline;
        }
        return null;
    }
}

