/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Action;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import org.kohsuke.stapler.export.ExportedBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionProxiesImpl
extends BlueActionProxy {
    private final Action action;
    private final Reachable parent;
    private static final Logger logger = LoggerFactory.getLogger(ActionProxiesImpl.class);

    public ActionProxiesImpl(Action action, Reachable parent) {
        this.action = action;
        this.parent = parent;
    }

    public Object getAction() {
        if (this.action.getClass().isAnnotationPresent(ExportedBean.class)) {
            return this.action;
        }
        return null;
    }

    public String getUrlName() {
        try {
            return this.action.getUrlName();
        }
        catch (Exception e) {
            logger.error(String.format("Error calling %s.getUrlName(): %s", this.action.getClass().getName(), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String get_Class() {
        return this.action.getClass().getName();
    }

    public Link getLink() {
        if (this.getUrlName() != null) {
            return this.parent.getLink().rel(this.getUrlName());
        }
        return null;
    }
}

