/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.service.embedded.rest;

import hudson.model.Action;
import hudson.model.Result;
import hudson.model.Run;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.rest.model.GenericResource;
import io.jenkins.blueocean.service.embedded.rest.AbstractPipelineImpl;
import io.jenkins.blueocean.service.embedded.rest.BlueRunFactory;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import io.jenkins.blueocean.service.embedded.rest.OrganizationImpl;
import io.jenkins.blueocean.service.embedded.rest.StoppableRun;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

public class AbstractRunImpl<T extends Run>
extends BlueRun {
    protected final T run;
    private final Link parent;

    public AbstractRunImpl(T run, Link parent) {
        this.run = run;
        this.parent = parent;
    }

    public Container<BlueChangeSetEntry> getChangeSet() {
        return null;
    }

    public String getOrganization() {
        return OrganizationImpl.INSTANCE.getName();
    }

    public String getId() {
        return this.run.getId();
    }

    public String getPipeline() {
        return this.run.getParent().getName();
    }

    public Date getStartTime() {
        return new Date(this.run.getStartTimeInMillis());
    }

    public Date getEnQueueTime() {
        return new Date(this.run.getTimeInMillis());
    }

    public BlueRun.BlueRunState getStateObj() {
        if (!this.run.hasntStartedYet() && this.run.isLogUpdated()) {
            return BlueRun.BlueRunState.RUNNING;
        }
        if (!this.run.isLogUpdated()) {
            return BlueRun.BlueRunState.FINISHED;
        }
        return BlueRun.BlueRunState.QUEUED;
    }

    public BlueRun.BlueRunResult getResult() {
        return this.run.getResult() != null ? BlueRun.BlueRunResult.valueOf((String)this.run.getResult().toString()) : BlueRun.BlueRunResult.UNKNOWN;
    }

    public Date getEndTime() {
        if (!this.run.isBuilding()) {
            return new Date(this.run.getStartTimeInMillis() + this.run.getDuration());
        }
        return null;
    }

    public Long getDurationInMillis() {
        return this.run.getDuration();
    }

    public Long getEstimatedDurtionInMillis() {
        return this.run.getEstimatedDuration();
    }

    public String getRunSummary() {
        return this.run.getBuildStatusSummary().message;
    }

    public String getType() {
        return this.run.getClass().getSimpleName();
    }

    public Object getLog() {
        return new LogResource(this.run.getLogText());
    }

    public BlueQueueItem replay() {
        return null;
    }

    public Container<BlueRun.BlueArtifact> getArtifacts() {
        HashMap<String, 1> m = new HashMap<String, 1>();
        List artifacts = this.run.getArtifacts();
        for (final Run.Artifact artifact : artifacts) {
            m.put(artifact.getFileName(), new BlueRun.BlueArtifact(){

                public String getName() {
                    return artifact.getFileName();
                }

                public String getUrl() {
                    return Stapler.getCurrentRequest().getContextPath() + "/" + AbstractRunImpl.this.run.getUrl() + "artifact/" + artifact.getHref();
                }

                public long getSize() {
                    try {
                        return artifact.getFileSize();
                    }
                    catch (NumberFormatException e) {
                        return 0L;
                    }
                }

                public Link getLink() {
                    return new Link(this.getUrl());
                }
            });
        }
        return Containers.fromResourceMap((Link)this.getLink(), m);
    }

    public BluePipelineNodeContainer getNodes() {
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return null;
    }

    public Collection<BlueActionProxy> getActions() {
        return AbstractPipelineImpl.getActionProxies(this.run.getAllActions(), (Reachable)this);
    }

    public static BlueRun getBlueRun(Run r, Reachable parent) {
        for (BlueRunFactory runFactory : BlueRunFactory.all()) {
            BlueRun blueRun = runFactory.getRun(r, parent);
            if (blueRun == null) continue;
            return blueRun;
        }
        return new AbstractRunImpl<Run>(r, parent.getLink());
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        throw new ServiceException.NotImplementedException("Stop should be implemented on a subclass");
    }

    protected BlueRun stop(Boolean blocking, Integer timeOutInSecs, StoppableRun stoppableRun) {
        if (blocking == null) {
            blocking = false;
        }
        try {
            long start = System.currentTimeMillis();
            if (timeOutInSecs == null) {
                timeOutInSecs = 10;
            }
            if (timeOutInSecs < 0) {
                throw new ServiceException.BadRequestExpception("timeOutInSecs must be >= 0");
            }
            long timeOutInMillis = timeOutInSecs * 1000;
            long sleepingInterval = timeOutInMillis / 10L;
            do {
                if (this.isCompletedOrAborted()) {
                    return this;
                }
                stoppableRun.stop();
                if (this.isCompletedOrAborted()) {
                    return this;
                }
                Thread.sleep(sleepingInterval);
            } while (blocking.booleanValue() && System.currentTimeMillis() - start < timeOutInMillis);
        }
        catch (Exception e) {
            throw new ServiceException.UnexpectedErrorException(String.format("Failed to stop run %s: %s", this.run.getId(), e.getMessage()), (Throwable)e);
        }
        return this;
    }

    public Object getDynamic(String token) {
        for (Action a : this.run.getAllActions()) {
            if (!token.equals(a.getUrlName())) continue;
            return new GenericResource((Object)a);
        }
        return null;
    }

    public Link getLink() {
        if (this.parent == null) {
            return OrganizationImpl.INSTANCE.getLink().rel(String.format("pipelines/%s/runs/%s", this.run.getParent().getName(), this.getId()));
        }
        return this.parent.rel("runs/" + this.getId());
    }

    private boolean isCompletedOrAborted() {
        return this.run.getResult() != null && (this.run.getResult() == Result.ABORTED || this.run.getResult().isCompleteBuild());
    }
}

