/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.hudson.plugins.folder.AbstractFolderPropertyDescriptor;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.model.TopLevelItem;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.ListBoxModel;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.pipeline.credential.Messages;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

@Extension(ordinal=99999.0)
public class BlueOceanCredentialsProvider
extends CredentialsProvider {
    private static final BlueOceanDomainRequirement PROXY_REQUIREMENT = new BlueOceanDomainRequirement();

    @Nonnull
    public <C extends Credentials> List<C> getCredentials(@Nonnull Class<C> type, @Nonnull ItemGroup itemGroup, @Nonnull Authentication authentication) {
        return this.getCredentials(type, itemGroup, authentication, Collections.emptyList());
    }

    @Nonnull
    public <C extends Credentials> List<C> getCredentials(final @Nonnull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nonnull List<DomainRequirement> domainRequirements) {
        final ArrayList result = new ArrayList();
        final FolderPropertyImpl prop = BlueOceanCredentialsProvider.propertyOf((ModelObject)itemGroup);
        if (prop != null && prop.domain.test(domainRequirements)) {
            Authentication proxyAuth;
            final User proxyUser = User.get((String)prop.getUser(), (boolean)false, Collections.emptyMap());
            Authentication authentication2 = proxyAuth = proxyUser == null ? null : proxyUser.impersonate();
            if (proxyAuth != null) {
                ACL.impersonate((Authentication)proxyAuth, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)proxyUser)) {
                            for (Domain d : s.getDomains()) {
                                if (!d.test(new DomainRequirement[]{PROXY_REQUIREMENT})) continue;
                                for (Credentials c : CredentialsMatchers.filter((List)s.getCredentials(d), (CredentialsMatcher)CredentialsMatchers.withId((String)prop.getId()))) {
                                    if (!type.isInstance(c)) continue;
                                    result.add(c);
                                }
                            }
                        }
                    }
                });
            }
        }
        return result;
    }

    @Nonnull
    public <C extends IdCredentials> ListBoxModel getCredentialIds(@Nonnull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @Nonnull List<DomainRequirement> domainRequirements, @Nonnull CredentialsMatcher matcher) {
        ListBoxModel result = new ListBoxModel();
        FolderPropertyImpl prop = BlueOceanCredentialsProvider.propertyOf((ModelObject)itemGroup);
        if (prop != null && prop.domain.test(domainRequirements)) {
            result.add(Messages.BlueOceanCredentialsProvider_DisplayName(), prop.getId());
        }
        return result;
    }

    @Nonnull
    public String getDisplayName() {
        return Messages.BlueOceanCredentialsProvider_DisplayName();
    }

    public CredentialsStore getStore(@CheckForNull ModelObject object) {
        FolderPropertyImpl property = BlueOceanCredentialsProvider.propertyOf(object);
        return property != null ? property.getStore() : null;
    }

    public Set<CredentialsScope> getScopes(ModelObject object) {
        return Collections.singleton(CredentialsScope.GLOBAL);
    }

    private boolean isApplicable(ModelObject object) {
        return object instanceof AbstractFolder && ((AbstractFolder)object).getProperties().get(FolderPropertyImpl.class) != null;
    }

    private static FolderPropertyImpl propertyOf(ModelObject object) {
        if (object instanceof AbstractFolder) {
            FolderPropertyImpl prop = (FolderPropertyImpl)((AbstractFolder)object).getProperties().get(FolderPropertyImpl.class);
            if (prop == null) {
                ItemGroup parent = ((AbstractFolder)object).getParent();
                if (parent instanceof Jenkins) {
                    return null;
                }
                return BlueOceanCredentialsProvider.propertyOf((ModelObject)parent);
            }
            return prop;
        }
        return null;
    }

    @Nonnull
    public static Domain createDomain(@Nonnull String uri) {
        return new Domain("blueocean-folder-credential-domain", Messages.BlueOceanCredentialsProvider_DomainDescription(), CredentialsUtils.generateDomainSpecifications(uri));
    }

    public static class FolderPropertyImpl
    extends AbstractFolderProperty<AbstractFolder<TopLevelItem>> {
        private final Domain domain;
        private final String user;
        private final String id;
        private transient StoreImpl store;

        @DataBoundConstructor
        public FolderPropertyImpl(@Nonnull String user, @Nonnull String id, @Nonnull Domain domain) {
            this.user = user;
            this.id = id;
            this.domain = domain;
        }

        public StoreImpl getStore() {
            if (this.store == null) {
                this.store = new StoreImpl();
            }
            return this.store;
        }

        @Nonnull
        public String getUser() {
            return this.user;
        }

        @Nonnull
        public String getId() {
            return this.id;
        }

        @Nonnull
        public Domain getDomain() {
            return this.domain;
        }

        public AbstractFolderProperty<?> reconfigure(StaplerRequest req, JSONObject form) throws Descriptor.FormException {
            return this;
        }

        public class StoreImpl
        extends CredentialsStore {
            private final CredentialsStoreAction storeAction;

            StoreImpl() {
                super(BlueOceanCredentialsProvider.class);
                this.storeAction = new CredentialsStoreActionImpl(this);
            }

            @Nonnull
            public List<Domain> getDomains() {
                return Collections.singletonList(FolderPropertyImpl.this.domain);
            }

            @Nullable
            public CredentialsStoreAction getStoreAction() {
                return this.storeAction;
            }

            @Nonnull
            public ModelObject getContext() {
                return FolderPropertyImpl.this.owner;
            }

            public boolean hasPermission(@Nonnull Authentication a, @Nonnull Permission permission) {
                if (permission == CredentialsProvider.CREATE || permission == CredentialsProvider.DELETE || permission == CredentialsProvider.MANAGE_DOMAINS || permission == CredentialsProvider.UPDATE) {
                    return false;
                }
                return FolderPropertyImpl.this.owner.getACL().hasPermission(a, permission);
            }

            @Nonnull
            public List<Credentials> getCredentials(@Nonnull Domain domain) {
                final ArrayList<Credentials> result = new ArrayList<Credentials>(1);
                if (domain.equals((Object)FolderPropertyImpl.this.domain)) {
                    Authentication proxyAuth;
                    final User proxyUser = User.get((String)FolderPropertyImpl.this.getUser(), (boolean)false, Collections.emptyMap());
                    Authentication authentication = proxyAuth = proxyUser == null ? null : proxyUser.impersonate();
                    if (proxyAuth != null) {
                        ACL.impersonate((Authentication)proxyAuth, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                for (CredentialsStore s : CredentialsProvider.lookupStores((ModelObject)proxyUser)) {
                                    for (Domain d : s.getDomains()) {
                                        if (!d.test(new DomainRequirement[]{PROXY_REQUIREMENT})) continue;
                                        result.addAll(CredentialsMatchers.filter((List)s.getCredentials(d), (CredentialsMatcher)CredentialsMatchers.withId((String)FolderPropertyImpl.this.getId())));
                                    }
                                }
                            }
                        });
                    }
                }
                return result;
            }

            public boolean addCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) throws IOException {
                throw new UnsupportedOperationException("Not supported");
            }

            public boolean removeCredentials(@Nonnull Domain domain, @Nonnull Credentials credentials) throws IOException {
                throw new UnsupportedOperationException("Not supported");
            }

            public boolean updateCredentials(@Nonnull Domain domain, @Nonnull Credentials current, @Nonnull Credentials replacement) throws IOException {
                throw new UnsupportedOperationException("Not supported");
            }
        }

        public static class CredentialsStoreActionImpl
        extends CredentialsStoreAction {
            private final CredentialsStore store;

            CredentialsStoreActionImpl(CredentialsStore store) {
                this.store = store;
            }

            @Nonnull
            public CredentialsStore getStore() {
                return this.store;
            }

            public String getIconFileName() {
                return this.isVisible() ? "/plugin/credentials/images/48x48/folder-store.png" : null;
            }

            public String getIconClassName() {
                return this.isVisible() ? "icon-credentials-folder-store" : null;
            }

            public String getDisplayName() {
                return Messages.BlueOceanCredentialsProvider_DisplayName();
            }

            public String getUrlName() {
                return super.getUrlName();
            }
        }

        @Extension
        public static class DescriptorImpl
        extends AbstractFolderPropertyDescriptor {
        }
    }
}

