/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.scm.api;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import hudson.model.Cause;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.User;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanCredentialsProvider;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.scm.api.AbstractPipelineCreateRequest;
import io.jenkins.blueocean.scm.api.AbstractScmSourceEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceEvent;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pubsub.Message;
import org.jenkinsci.plugins.pubsub.MessageException;
import org.jenkinsci.plugins.pubsub.PubsubBus;
import org.jenkinsci.plugins.pubsub.SimpleMessage;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultiBranchCreateRequest
extends AbstractPipelineCreateRequest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMultiBranchCreateRequest.class);
    private static final String DESCRIPTOR_NAME = "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject";
    private static final String ERROR_FIELD_SCM_CONFIG_URI = "scmConfig.uri";
    private static final String ERROR_FIELD_SCM_CONFIG_NAME = "scmConfig.name";
    private static final String ERROR_NAME = "name";
    private static final String ERROR_FIELD_SCM_CREDENTIAL_ID = "scm.credentialId";

    public AbstractMultiBranchCreateRequest(String name, BlueScmConfig scmConfig) {
        super(name, scmConfig);
    }

    public BluePipeline create(@Nonnull BlueOrganization organization, @Nonnull Reachable parent) throws IOException {
        this.validateInternal(this.getName(), this.scmConfig, organization);
        MultiBranchProject project = this.createMultiBranchProject(organization);
        this.assignCredentialToProject(this.scmConfig, project);
        SCMSource source = this.createSource(project, this.scmConfig).withId("blueocean");
        project.setSourcesList((List)ImmutableList.of((Object)new BranchSource(source)));
        project.save();
        boolean hasJenkinsfile = this.repoHasJenkinsFile(source);
        if (!hasJenkinsfile) {
            this.sendMultibranchIndexingCompleteEvent(project, 5);
            AbstractScmSourceEvent scmSourceEvent = this.getScmSourceEvent(project, source);
            if (scmSourceEvent != null) {
                SCMSourceEvent.fireNow((SCMSourceEvent)scmSourceEvent);
            }
        } else {
            project.scheduleBuild((Cause)new Cause.UserIdCause());
        }
        return BluePipelineFactory.getPipelineInstance((Item)project, (Reachable)OrganizationFactory.getInstance().getContainingOrg(project.getItemGroup()));
    }

    @Nullable
    protected AbstractScmSourceEvent getScmSourceEvent(@Nonnull MultiBranchProject project, @Nonnull SCMSource source) {
        return null;
    }

    protected abstract SCMSource createSource(@Nonnull MultiBranchProject var1, @Nonnull BlueScmConfig var2);

    protected abstract List<ErrorMessage.Error> validate(String var1, BlueScmConfig var2);

    protected boolean repoHasJenkinsFile(@Nonnull SCMSource scmSource) {
        final JenkinsfileCriteria criteria = new JenkinsfileCriteria();
        try {
            scmSource.fetch((SCMSourceCriteria)criteria, new SCMHeadObserver(){

                public void observe(@Nonnull SCMHead head, @Nonnull SCMRevision revision) throws IOException, InterruptedException {
                }

                public boolean isObserving() {
                    return !criteria.isJenkinsfileFound();
                }
            }, TaskListener.NULL);
        }
        catch (IOException | InterruptedException e) {
            logger.warn("Error detecting Jenkinsfile: " + e.getMessage(), (Throwable)e);
        }
        return criteria.isJenkinsfileFound();
    }

    private void sendMultibranchIndexingCompleteEvent(final MultiBranchProject mbp, final int iterations) {
        Executors.newScheduledThreadPool(1).schedule(new Runnable(){

            @Override
            public void run() {
                AbstractMultiBranchCreateRequest.this._sendMultibranchIndexingCompleteEvent(mbp, iterations);
            }
        }, 1L, TimeUnit.SECONDS);
    }

    private void _sendMultibranchIndexingCompleteEvent(MultiBranchProject mbp, int iterations) {
        try {
            SimpleMessage msg = new SimpleMessage();
            msg.set("jenkins_object_type", DESCRIPTOR_NAME);
            msg.set("job_run_status", "ALLOCATED");
            msg.set("job_name", mbp.getName());
            msg.set("jenkins_org", "jenkins");
            msg.set("job_orgfolder_indexing_status", "COMPLETE");
            msg.set("job_run_queueId", "1");
            msg.set("jenkins_object_name", mbp.getName());
            msg.set("blueocean_job_rest_url", "/blue/rest/organizations/jenkins/pipelines/" + mbp.getName() + "/");
            msg.set("jenkins_event", "job_run_queue_task_complete");
            msg.set("job_multibranch_indexing_result", "SUCCESS");
            msg.set("blueocean_job_pipeline_name", mbp.getName());
            msg.set("jenkins_object_url", "job/" + mbp.getName() + "/");
            msg.set("jenkins_channel", "job");
            msg.set("jenkinsfile_present", "false");
            PubsubBus.getBus().publish((Message)msg);
        }
        catch (MessageException e) {
            throw new RuntimeException(e);
        }
    }

    private MultiBranchProject createMultiBranchProject(BlueOrganization organization) throws IOException {
        TopLevelItem item = this.createProject(this.getName(), DESCRIPTOR_NAME, MultiBranchProjectDescriptor.class, organization);
        if (!(item instanceof WorkflowMultiBranchProject)) {
            try {
                item.delete();
            }
            catch (InterruptedException e) {
                throw new ServiceException.UnexpectedErrorException("Failed to delete pipeline: " + this.getName());
            }
        }
        return (MultiBranchProject)item;
    }

    private void assignCredentialToProject(BlueScmConfig scmConfig, MultiBranchProject project) throws IOException {
        User authenticatedUser = User.current();
        String credentialId = this.computeCredentialId(scmConfig);
        if (StringUtils.isNotBlank((String)credentialId)) {
            Domain domain = CredentialsUtils.findDomain(credentialId, authenticatedUser);
            if (domain == null) {
                throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline").add(new ErrorMessage.Error(ERROR_FIELD_SCM_CREDENTIAL_ID, ErrorMessage.Error.ErrorCodes.INVALID.toString(), "No domain in user credentials found for credentialId: " + credentialId)));
            }
            if (StringUtils.isEmpty((String)scmConfig.getUri())) {
                throw new ServiceException.BadRequestException("uri not specified");
            }
            if (domain.test(new DomainRequirement[]{new BlueOceanDomainRequirement()})) {
                project.addProperty((AbstractFolderProperty)new BlueOceanCredentialsProvider.FolderPropertyImpl(authenticatedUser.getId(), credentialId, BlueOceanCredentialsProvider.createDomain(scmConfig.getUri())));
            }
        }
    }

    private void validateInternal(String name, BlueScmConfig scmConfig, BlueOrganization organization) {
        this.checkUserIsAuthenticatedAndHasItemCreatePermission(organization);
        if (scmConfig == null) {
            throw AbstractMultiBranchCreateRequest.fail(new ErrorMessage.Error("scmConfig", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig is required"));
        }
        if (scmConfig.getUri() == null) {
            throw AbstractMultiBranchCreateRequest.fail(new ErrorMessage.Error(ERROR_FIELD_SCM_CONFIG_URI, ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig.uri is required"));
        }
        if (this.getName() == null) {
            throw AbstractMultiBranchCreateRequest.fail(new ErrorMessage.Error(ERROR_FIELD_SCM_CONFIG_NAME, ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig.name is required"));
        }
        LinkedList errors = Lists.newLinkedList(this.validate(name, scmConfig));
        try {
            Jenkins.getInstance().getProjectNamingStrategy().checkName(this.getName());
            Jenkins.checkGoodName((String)name);
        }
        catch (Failure f) {
            errors.add(new ErrorMessage.Error(ERROR_FIELD_SCM_CONFIG_NAME, ErrorMessage.Error.ErrorCodes.INVALID.toString(), this.getName() + " in not a valid name"));
        }
        ModifiableTopLevelItemGroup parent = this.getParent(organization);
        if (parent.getItem(name) != null) {
            errors.add(new ErrorMessage.Error(ERROR_NAME, ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), this.getName() + " already exists"));
        }
        if (!errors.isEmpty()) {
            throw AbstractMultiBranchCreateRequest.fail(errors);
        }
    }

    private static ServiceException fail(List<ErrorMessage.Error> errors) {
        ErrorMessage errorMessage = new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline");
        errorMessage.addAll(errors);
        return new ServiceException.BadRequestException(errorMessage);
    }

    private static ServiceException fail(ErrorMessage.Error ... errors) {
        return AbstractMultiBranchCreateRequest.fail(Arrays.asList(errors));
    }

    public static class JenkinsfileCriteria
    implements SCMSourceCriteria {
        private static final long serialVersionUID = 1L;
        private AtomicBoolean jenkinsFileFound = new AtomicBoolean();

        public boolean isHead(@Nonnull SCMSourceCriteria.Probe probe, @Nonnull TaskListener listener) throws IOException {
            boolean foundJenkinsFile;
            SCMProbeStat stat = probe.stat("Jenkinsfile");
            boolean bl = foundJenkinsFile = stat.getType() != SCMFile.Type.NONEXISTENT && stat.getType() != SCMFile.Type.DIRECTORY;
            if (foundJenkinsFile && !this.jenkinsFileFound.get()) {
                this.jenkinsFileFound.set(true);
            }
            return foundJenkinsFile;
        }

        public boolean isJenkinsfileFound() {
            return this.jenkinsFileFound.get();
        }
    }
}

