/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.scm.api;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineCreateRequest;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.acegisecurity.Authentication;

public abstract class AbstractPipelineCreateRequest
extends BluePipelineCreateRequest {
    protected final BlueScmConfig scmConfig;

    public AbstractPipelineCreateRequest(String name, BlueScmConfig scmConfig) {
        this.setName(name);
        Collection organizations = OrganizationFactory.getInstance().list();
        if (organizations.isEmpty()) {
            throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Pipeline creation failed. Failed to find organization"));
        }
        this.setOrganization(((BlueOrganization)organizations.iterator().next()).getName());
        this.scmConfig = scmConfig;
    }

    @Nonnull
    protected TopLevelItem createProject(String name, String descriptorName, Class<? extends TopLevelItemDescriptor> descriptorClass) throws IOException {
        Authentication authentication;
        ModifiableTopLevelItemGroup itemGroup = this.getParent();
        TopLevelItemDescriptor descriptor = (TopLevelItemDescriptor)Items.all().findByName(descriptorName);
        if (descriptor == null || !descriptorClass.isAssignableFrom(descriptor.getClass())) {
            throw new ServiceException.BadRequestException(String.format("Failed to create pipeline: %s, descriptor %s is not found", name, descriptorName));
        }
        if (!descriptor.isApplicableIn((ItemGroup)itemGroup)) {
            throw new ServiceException.ForbiddenException(String.format("Failed to create pipeline: %s. Pipeline can't be created in Jenkins root folder", name));
        }
        ACL acl = itemGroup instanceof AccessControlled ? ((AccessControlled)itemGroup).getACL() : Jenkins.getInstance().getACL();
        if (!acl.hasCreatePermission(authentication = Jenkins.getAuthentication(), (ItemGroup)itemGroup, descriptor)) {
            throw new ServiceException.ForbiddenException("Missing permission: " + Item.CREATE.group.title + "/" + Item.CREATE.name + " " + Item.CREATE + "/" + descriptor.getDisplayName());
        }
        return itemGroup.createProject(descriptor, name, true);
    }

    protected ModifiableTopLevelItemGroup getParent() {
        String organization = this.getOrganization();
        ModifiableTopLevelItemGroup parent = OrganizationFactory.getItemGroup((String)this.getOrganization());
        if (parent == null) {
            throw new ServiceException.BadRequestException("Invalid Jenkins organization. " + organization);
        }
        return parent;
    }

    protected User checkUserIsAuthenticatedAndHasItemCreatePermission() {
        ACL acl;
        User authenticatedUser = User.current();
        if (authenticatedUser == null) {
            throw new ServiceException.UnauthorizedException("Must be logged in to create a pipeline");
        }
        Authentication authentication = Jenkins.getAuthentication();
        ModifiableTopLevelItemGroup p = this.getParent();
        ACL aCL = acl = p instanceof AccessControlled ? ((AccessControlled)p).getACL() : Jenkins.getInstance().getACL();
        if (!acl.hasPermission(authentication, Item.CREATE)) {
            throw new ServiceException.ForbiddenException(String.format("User %s doesn't have Job create permission", authenticatedUser.getId()));
        }
        return authenticatedUser;
    }
}

