/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.scm.api;

import com.cloudbees.hudson.plugins.folder.AbstractFolderProperty;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.collect.Lists;
import hudson.model.Cause;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.TopLevelItem;
import hudson.model.User;
import io.jenkins.blueocean.commons.ErrorMessage;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.credential.CredentialsUtils;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BluePipelineFactory;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanCredentialsProvider;
import io.jenkins.blueocean.rest.impl.pipeline.credential.BlueOceanDomainRequirement;
import io.jenkins.blueocean.rest.model.BluePipeline;
import io.jenkins.blueocean.rest.model.BlueScmConfig;
import io.jenkins.blueocean.scm.api.AbstractPipelineCreateRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMSource;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;

public abstract class AbstractMultiBranchCreateRequest
extends AbstractPipelineCreateRequest {
    private static final String DESCRIPTOR_NAME = "org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject";
    private static final String ERROR_FIELD_SCM_CONFIG_URI = "scmConfig.uri";
    private static final String ERROR_FIELD_SCM_CONFIG_NAME = "scmConfig.name";
    private static final String ERROR_NAME = "name";
    private static final String ERROR_FIELD_SCM_CREDENTIAL_ID = "scm.credentialId";

    public AbstractMultiBranchCreateRequest(String name, BlueScmConfig scmConfig) {
        super(name, scmConfig);
    }

    public BluePipeline create(Reachable parent) throws IOException {
        this.validateInternal(this.getName(), this.scmConfig);
        MultiBranchProject project = this.createMultiBranchProject();
        this.assignCredentialToProject(this.scmConfig, project);
        SCMSource source = this.createSource(project, this.scmConfig);
        project.getSourcesList().add((Object)new BranchSource(source));
        project.save();
        project.scheduleBuild((Cause)new Cause.UserIdCause());
        return BluePipelineFactory.getPipelineInstance((Item)project, (Reachable)OrganizationFactory.getInstance().getContainingOrg(project.getItemGroup()));
    }

    protected abstract SCMSource createSource(@Nonnull MultiBranchProject var1, @Nonnull BlueScmConfig var2);

    protected abstract List<ErrorMessage.Error> validate(String var1, BlueScmConfig var2);

    private MultiBranchProject createMultiBranchProject() throws IOException {
        TopLevelItem item = this.createProject(this.getName(), DESCRIPTOR_NAME, MultiBranchProjectDescriptor.class);
        if (!(item instanceof WorkflowMultiBranchProject)) {
            try {
                item.delete();
            }
            catch (InterruptedException e) {
                throw new ServiceException.UnexpectedErrorException("Failed to delete pipeline: " + this.getName());
            }
        }
        return (MultiBranchProject)item;
    }

    private void assignCredentialToProject(BlueScmConfig scmConfig, MultiBranchProject project) throws IOException {
        User authenticatedUser = User.current();
        if (StringUtils.isNotBlank((String)scmConfig.getCredentialId())) {
            Domain domain = CredentialsUtils.findDomain(scmConfig.getCredentialId(), authenticatedUser);
            if (domain == null) {
                throw new ServiceException.BadRequestException(new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline").add(new ErrorMessage.Error(ERROR_FIELD_SCM_CREDENTIAL_ID, ErrorMessage.Error.ErrorCodes.INVALID.toString(), "No domain in user credentials found for credentialId: " + scmConfig.getCredentialId())));
            }
            if (StringUtils.isEmpty((String)scmConfig.getUri())) {
                throw new ServiceException.BadRequestException("uri not specified");
            }
            if (domain.test(new DomainRequirement[]{new BlueOceanDomainRequirement()})) {
                project.addProperty((AbstractFolderProperty)new BlueOceanCredentialsProvider.FolderPropertyImpl(authenticatedUser.getId(), scmConfig.getCredentialId(), BlueOceanCredentialsProvider.createDomain(scmConfig.getUri())));
            }
        }
    }

    private void validateInternal(String name, BlueScmConfig scmConfig) {
        this.checkUserIsAuthenticatedAndHasItemCreatePermission();
        if (scmConfig == null) {
            throw AbstractMultiBranchCreateRequest.fail(new ErrorMessage.Error("scmConfig", ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig is required"));
        }
        if (scmConfig.getUri() == null) {
            throw AbstractMultiBranchCreateRequest.fail(new ErrorMessage.Error(ERROR_FIELD_SCM_CONFIG_URI, ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig.uriis required"));
        }
        if (this.getName() == null) {
            throw AbstractMultiBranchCreateRequest.fail(new ErrorMessage.Error(ERROR_FIELD_SCM_CONFIG_NAME, ErrorMessage.Error.ErrorCodes.MISSING.toString(), "scmConfig.name is required"));
        }
        LinkedList errors = Lists.newLinkedList(this.validate(name, scmConfig));
        try {
            Jenkins.getInstance().getProjectNamingStrategy().checkName(this.getName());
        }
        catch (Failure f) {
            errors.add(new ErrorMessage.Error(ERROR_FIELD_SCM_CONFIG_NAME, ErrorMessage.Error.ErrorCodes.INVALID.toString(), this.getName() + " in not a valid name"));
        }
        if (this.getParent().getItem(name) != null) {
            errors.add(new ErrorMessage.Error(ERROR_NAME, ErrorMessage.Error.ErrorCodes.ALREADY_EXISTS.toString(), this.getName() + " already exists"));
        }
        if (!errors.isEmpty()) {
            throw AbstractMultiBranchCreateRequest.fail(errors);
        }
    }

    private static ServiceException fail(List<ErrorMessage.Error> errors) {
        ErrorMessage errorMessage = new ErrorMessage(Integer.valueOf(400), "Failed to create pipeline");
        errorMessage.addAll(errors);
        return new ServiceException.BadRequestException(errorMessage);
    }

    private static ServiceException fail(ErrorMessage.Error ... errors) {
        return AbstractMultiBranchCreateRequest.fail(Arrays.asList(errors));
    }
}

