/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline.credential;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import hudson.Extension;
import hudson.model.ModelObject;
import hudson.model.User;
import io.jenkins.blueocean.rest.OrganizationRoute;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.organization.OrganizationFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.credential.CredentialApi;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.Container;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nonnull;
import jenkins.model.ModifiableTopLevelItemGroup;
import org.kohsuke.stapler.export.ExportedBean;

@Extension
@ExportedBean
public class CredentialContainer
extends Container<CredentialApi>
implements OrganizationRoute {
    private final Link self;

    public CredentialContainer() {
        Iterator iterator = OrganizationFactory.getInstance().list().iterator();
        BlueOrganization organization = iterator.hasNext() ? (BlueOrganization)iterator.next() : null;
        this.self = organization != null ? organization.getLink().rel("credentials") : null;
    }

    public CredentialContainer(@Nonnull Link parent) {
        this.self = parent.rel("credentials");
    }

    public String getUrlName() {
        return "credentials";
    }

    public Link getLink() {
        return this.self;
    }

    public CredentialApi get(String name) {
        Iterator<CredentialApi> iterator = this.iterator();
        while (iterator.hasNext()) {
            CredentialApi api = iterator.next();
            if (!api.getStore().equals(name)) continue;
            return api;
        }
        return null;
    }

    public Iterator<CredentialApi> iterator() {
        ArrayList<CredentialApi> apis;
        block3: {
            BlueOrganization organization;
            block2: {
                apis = new ArrayList<CredentialApi>();
                User user = User.current();
                if (user == null) break block2;
                for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)user)) {
                    if (store.getStoreAction() == null) continue;
                    apis.add(new CredentialApi(store.getStoreAction(), (Reachable)this));
                }
                break block3;
            }
            Iterator iterator = OrganizationFactory.getInstance().list().iterator();
            BlueOrganization blueOrganization = organization = iterator.hasNext() ? (BlueOrganization)iterator.next() : null;
            if (organization == null) break block3;
            ModifiableTopLevelItemGroup itemGroup = OrganizationFactory.getItemGroup((String)organization.getName());
            for (CredentialsStore store : CredentialsProvider.lookupStores((ModelObject)itemGroup)) {
                if (store.getStoreAction() == null) continue;
                apis.add(new CredentialApi(store.getStoreAction(), (Reachable)this));
            }
        }
        return apis.iterator();
    }
}

