/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.StaplerRequest;

public abstract class ScmContentProvider
implements ExtensionPoint {
    @Nonnull
    public abstract String getScmId();

    @CheckForNull
    public abstract String getApiUrl(@Nonnull Item var1);

    @CheckForNull
    public abstract Object getContent(@Nonnull StaplerRequest var1, @Nonnull Item var2);

    @CheckForNull
    public abstract Object saveContent(@Nonnull StaplerRequest var1, @Nonnull Item var2);

    public abstract boolean support(@Nonnull Item var1);

    public static ScmContentProvider resolve(@Nonnull Item item) {
        for (ScmContentProvider provider : ScmContentProvider.all()) {
            if (!provider.support(item)) continue;
            return provider;
        }
        return null;
    }

    public static ExtensionList<ScmContentProvider> all() {
        return ExtensionList.lookup(ScmContentProvider.class);
    }
}

