/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStep;
import org.jenkinsci.plugins.workflow.support.steps.input.InputStepExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStepVisitor
extends StandardChunkVisitor {
    private final FlowNode node;
    private final WorkflowRun run;
    private final ArrayDeque<FlowNodeWrapper> steps = new ArrayDeque();
    private final ArrayDeque<FlowNodeWrapper> preSteps = new ArrayDeque();
    private final ArrayDeque<FlowNodeWrapper> postSteps = new ArrayDeque();
    private final Map<String, FlowNodeWrapper> stepMap = new HashMap<String, FlowNodeWrapper>();
    private boolean stageStepsCollectionCompleted = false;
    private boolean inStageScope;
    private FlowNode currentStage;
    private ArrayDeque<String> stages = new ArrayDeque();
    private InputAction inputAction;
    private StepEndNode closestEndNode;
    private StepStartNode agentNode = null;
    private static final Logger logger = LoggerFactory.getLogger(PipelineStepVisitor.class);

    public PipelineStepVisitor(WorkflowRun run, @Nullable FlowNode node) {
        this.node = node;
        this.run = run;
        this.inputAction = (InputAction)run.getAction(InputAction.class);
    }

    public void parallelBranchStart(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchStartNode, @Nonnull ForkScanner scanner) {
        if (this.stageStepsCollectionCompleted) {
            return;
        }
        if (this.node != null && branchStartNode.equals((Object)this.node)) {
            this.stageStepsCollectionCompleted = true;
        } else if (this.node != null && PipelineNodeUtil.isParallelBranch(this.node) && !branchStartNode.equals((Object)this.node)) {
            this.resetSteps();
        }
    }

    public void parallelBranchEnd(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchEndNode, @Nonnull ForkScanner scanner) {
        if (!this.stageStepsCollectionCompleted && this.node != null && PipelineNodeUtil.isParallelBranch(this.node) && branchEndNode instanceof StepEndNode) {
            this.resetSteps();
        }
    }

    public void chunkStart(@Nonnull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @Nonnull ForkScanner scanner) {
        super.chunkStart(startNode, beforeBlock, scanner);
        if (PipelineNodeUtil.isStage(startNode) && !PipelineNodeUtil.isSyntheticStage(startNode)) {
            this.stages.push(startNode.getId());
        }
    }

    public void chunkEnd(@Nonnull FlowNode endNode, @CheckForNull FlowNode afterChunk, @Nonnull ForkScanner scanner) {
        super.chunkEnd(endNode, afterChunk, scanner);
        if (endNode instanceof StepEndNode && PipelineNodeUtil.isStage((FlowNode)((StepEndNode)endNode).getStartNode())) {
            this.currentStage = ((StepEndNode)endNode).getStartNode();
        }
        if (this.node != null && endNode instanceof StepEndNode && ((StepStartNode)((StepEndNode)endNode).getStartNode()).equals((Object)this.node)) {
            this.stageStepsCollectionCompleted = false;
            this.inStageScope = true;
        }
        if (endNode instanceof StepStartNode && PipelineNodeUtil.isAgentStart(endNode)) {
            this.agentNode = (StepStartNode)endNode;
        }
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterChunk, scanner);
        }
    }

    protected void handleChunkDone(@Nonnull MemoryFlowChunk chunk) {
        if (this.stageStepsCollectionCompleted) {
            return;
        }
        if (this.node != null && chunk.getFirstNode().equals((Object)this.node)) {
            this.stageStepsCollectionCompleted = true;
            this.inStageScope = false;
            final String cause = PipelineNodeUtil.getCauseOfBlockage(chunk.getFirstNode(), (FlowNode)this.agentNode);
            if (cause != null) {
                AtomNode step = new AtomNode(chunk.getFirstNode().getExecution(), UUID.randomUUID().toString(), new FlowNode[]{chunk.getFirstNode()}){

                    protected String getTypeDisplayName() {
                        return cause;
                    }
                };
                FlowNodeWrapper stepNode = new FlowNodeWrapper((FlowNode)step, new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.QUEUED), new TimingInfo(), this.run);
                this.steps.push(stepNode);
                this.stepMap.put(step.getId(), stepNode);
            }
        }
        if (this.node != null && PipelineNodeUtil.isStage(this.node) && !this.inStageScope && !chunk.getFirstNode().equals((Object)this.node)) {
            this.resetSteps();
        }
    }

    public void atomNode(@CheckForNull FlowNode before, @Nonnull FlowNode atomNode, @CheckForNull FlowNode after, @Nonnull ForkScanner scan) {
        if (this.stageStepsCollectionCompleted && !PipelineNodeUtil.isSyntheticStage(this.currentStage)) {
            return;
        }
        if (atomNode instanceof StepEndNode) {
            this.closestEndNode = (StepEndNode)atomNode;
        }
        if (atomNode instanceof StepAtomNode && !PipelineNodeUtil.isSkippedStage(this.currentStage)) {
            NodeRunStatus status;
            long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
            this.chunk.setPauseTimeMillis(this.chunk.getPauseTimeMillis() + pause);
            TimingInfo times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)pause, (FlowNode)atomNode, (FlowNode)atomNode, (FlowNode)after);
            if (times == null) {
                times = new TimingInfo();
            }
            InputStep inputStep = null;
            if (PipelineNodeUtil.isPausedForInputStep((StepAtomNode)atomNode, this.inputAction)) {
                status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.PAUSED);
                try {
                    for (InputStepExecution execution : this.inputAction.getExecutions()) {
                        FlowNode node = (FlowNode)execution.getContext().get(FlowNode.class);
                        if (node == null || !node.equals((Object)atomNode)) continue;
                        inputStep = execution.getInput();
                    }
                }
                catch (IOException | InterruptedException | TimeoutException e) {
                    logger.error("Error getting FlowNode from execution context: " + e.getMessage(), (Throwable)e);
                }
            } else {
                status = new NodeRunStatus(atomNode);
            }
            FlowNodeWrapper node = new FlowNodeWrapper(atomNode, status, times, inputStep, this.run);
            if (PipelineNodeUtil.isPreSyntheticStage(this.currentStage)) {
                this.preSteps.add(node);
            } else if (PipelineNodeUtil.isPostSyntheticStage(this.currentStage)) {
                this.postSteps.add(node);
            } else if (!this.steps.contains(node)) {
                this.steps.push(node);
            }
            this.stepMap.put(node.getId(), node);
            if (this.closestEndNode != null && this.closestEndNode.getError() != null && new NodeRunStatus((FlowNode)before).result != BlueRun.BlueRunResult.FAILURE) {
                node.setBlockErrorAction(this.closestEndNode.getError());
                this.closestEndNode = null;
            }
        }
    }

    public List<FlowNodeWrapper> getSteps() {
        ArrayList<FlowNodeWrapper> s = new ArrayList<FlowNodeWrapper>();
        if (this.node != null) {
            if (PipelineNodeUtil.isSkippedStage(this.node)) {
                return Collections.emptyList();
            }
            String first = null;
            String last = null;
            if (!this.stages.isEmpty()) {
                first = this.stages.getFirst();
                last = this.stages.getLast();
            }
            if (first != null && this.node.getId().equals(first)) {
                s.addAll(this.preSteps);
            }
            s.addAll(this.steps);
            if (last != null && this.node.getId().equals(last)) {
                s.addAll(this.postSteps);
            }
        } else {
            s.addAll(this.preSteps);
            s.addAll(this.steps);
            s.addAll(this.postSteps);
        }
        return s;
    }

    public FlowNodeWrapper getStep(String id) {
        return this.stepMap.get(id);
    }

    private void resetSteps() {
        this.steps.clear();
        this.stepMap.clear();
    }
}

