/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.scm.ChangeLogSet;
import io.jenkins.blueocean.commons.ServiceException;
import io.jenkins.blueocean.rest.Navigable;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.annotation.Capability;
import io.jenkins.blueocean.rest.factory.BlueRunFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.BranchImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeContainerImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueChangeSetEntry;
import io.jenkins.blueocean.rest.model.BlueOrganization;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineNodeContainer;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueQueueItem;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.rest.model.Container;
import io.jenkins.blueocean.rest.model.Containers;
import io.jenkins.blueocean.service.embedded.rest.AbstractRunImpl;
import io.jenkins.blueocean.service.embedded.rest.ChangeSetResource;
import io.jenkins.blueocean.service.embedded.rest.QueueUtil;
import io.jenkins.blueocean.service.embedded.rest.StoppableRun;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.scm.api.SCMRevisionAction;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayAction;
import org.jenkinsci.plugins.workflow.cps.replay.ReplayCause;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.support.steps.ExecutorStepExecution;
import org.jenkinsci.plugins.workflow.support.steps.input.InputAction;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.export.Exported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Capability(value={"org.jenkinsci.plugins.workflow.job.WorkflowRun"})
public class PipelineRunImpl
extends AbstractRunImpl<WorkflowRun> {
    private static final Logger logger = LoggerFactory.getLogger(PipelineRunImpl.class);
    static final Comparator<BlueRun> LATEST_RUN_START_TIME_COMPARATOR = new Comparator<BlueRun>(){

        @Override
        public int compare(BlueRun o1, BlueRun o2) {
            Long t1 = o1 != null && o1.getStartTime() != null ? o1.getStartTime().getTime() : 0L;
            Long t2 = o2 != null && o2.getStartTime() != null ? o2.getStartTime().getTime() : 0L;
            return t2.compareTo(t1);
        }
    };

    public PipelineRunImpl(WorkflowRun run, Reachable parent, BlueOrganization organization) {
        super((Run)run, parent, organization);
    }

    @Exported(name="description")
    public String getDescription() {
        return ((WorkflowRun)this.run).getDescription();
    }

    @Exported(name="branch", inline=true)
    public BranchImpl.Branch getBranch() {
        return BranchImpl.Branch.getBranch(((WorkflowRun)this.run).getParent());
    }

    @Exported(name="pullRequest", inline=true)
    public BranchImpl.PullRequest getPullRequest() {
        return BranchImpl.PullRequest.get(((WorkflowRun)this.run).getParent());
    }

    @Nonnull
    public Container<BlueChangeSetEntry> getChangeSet() {
        ReplayCause replayCause = (ReplayCause)((WorkflowRun)this.run).getCause(ReplayCause.class);
        if (replayCause != null) {
            WorkflowRun run = ((WorkflowJob)((WorkflowRun)this.run).getParent()).getBuildByNumber(replayCause.getOriginalNumber());
            if (run == null) {
                return Containers.empty((Link)this.getLink());
            }
            BlueRun blueRun = BlueRunFactory.getRun((Run)run, (Reachable)this.parent);
            if (blueRun == null) {
                return Containers.empty((Link)this.getLink());
            }
            return blueRun.getChangeSet();
        }
        LinkedHashMap<String, ChangeSetResource> m = new LinkedHashMap<String, ChangeSetResource>();
        int cnt = 0;
        for (ChangeLogSet cs : ((WorkflowRun)this.run).getChangeSets()) {
            for (ChangeLogSet.Entry e : cs) {
                ++cnt;
                String id = e.getCommitId();
                if (id == null) {
                    id = String.valueOf(cnt);
                }
                m.put(id, new ChangeSetResource(this.organization, e, (Reachable)this));
            }
        }
        return Containers.fromResourceMap((Link)this.getLink(), m);
    }

    public BlueRun.BlueRunState getStateObj() {
        InputAction inputAction = (InputAction)((WorkflowRun)this.run).getAction(InputAction.class);
        try {
            if (inputAction != null && inputAction.getExecutions().size() > 0) {
                return BlueRun.BlueRunState.PAUSED;
            }
        }
        catch (InterruptedException | TimeoutException e) {
            logger.error("Error getting StateObject from execution context: " + e.getMessage(), (Throwable)e);
        }
        boolean isQueued = false;
        boolean isRunning = false;
        String causeOfBlockage = this.getCauseOfBlockage();
        for (BluePipelineNode n : this.getNodes()) {
            BlueRun.BlueRunState nodeState = n.getStateObj();
            if (nodeState == null) {
                if (causeOfBlockage != null) {
                    isQueued = true;
                    continue;
                }
                isRunning = true;
                continue;
            }
            if (nodeState.equals((Object)BlueRun.BlueRunState.QUEUED)) {
                isQueued = true;
                continue;
            }
            if (!nodeState.equals((Object)BlueRun.BlueRunState.RUNNING)) continue;
            isRunning = true;
        }
        if (!isRunning && (isQueued || causeOfBlockage != null)) {
            return BlueRun.BlueRunState.QUEUED;
        }
        return super.getStateObj();
    }

    public BlueRun replay() {
        ReplayAction replayAction = (ReplayAction)((WorkflowRun)this.run).getAction(ReplayAction.class);
        if (!this.isReplayable(replayAction)) {
            throw new ServiceException.BadRequestException("This run does not support replay");
        }
        Queue.Item item = replayAction.run2(replayAction.getOriginalScript(), replayAction.getOriginalLoadedScripts());
        if (item == null) {
            throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
        }
        BlueQueueItem queueItem = QueueUtil.getQueuedItem((BlueOrganization)this.organization, (Queue.Item)item, (Job)((WorkflowRun)this.run).getParent());
        WorkflowRun replayedRun = (WorkflowRun)QueueUtil.getRun((Job)((WorkflowRun)this.run).getParent(), (long)item.getId());
        if (queueItem != null) {
            return queueItem.toRun();
        }
        if (replayedRun != null) {
            return new PipelineRunImpl(replayedRun, this.parent, this.organization);
        }
        throw new ServiceException.UnexpectedErrorException("Run was not added to queue.");
    }

    public boolean isReplayable() {
        ReplayAction replayAction = (ReplayAction)((WorkflowRun)this.run).getAction(ReplayAction.class);
        return this.isReplayable(replayAction);
    }

    private boolean isReplayable(ReplayAction replayAction) {
        return replayAction != null && replayAction.isEnabled();
    }

    @Navigable
    public BluePipelineNodeContainer getNodes() {
        if (this.run != null) {
            return new PipelineNodeContainerImpl((WorkflowRun)this.run, this.getLink());
        }
        return null;
    }

    @Navigable
    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl((WorkflowRun)this.run, this.getLink());
    }

    public BlueRun stop(@QueryParameter(value="blocking") Boolean blocking, @QueryParameter(value="timeOutInSecs") Integer timeOutInSecs) {
        return this.stop(blocking, timeOutInSecs, new StoppableRun(){

            public void stop() {
                ((WorkflowRun)PipelineRunImpl.this.run).doStop();
            }
        });
    }

    @Exported(name="commitId")
    public String getCommitId() {
        SCMRevisionAction data = (SCMRevisionAction)((WorkflowRun)this.run).getAction(SCMRevisionAction.class);
        if (data != null) {
            return data.getRevision().toString();
        }
        return null;
    }

    @Exported(name="commitUrl")
    public String getCommitUrl() {
        String commitId = this.getCommitId();
        if (commitId != null) {
            Container changeSets = this.getChangeSet();
            int buildNumber = ((WorkflowRun)this.run).number;
            WorkflowJob job = (WorkflowJob)((WorkflowRun)this.run).getParent();
            while (buildNumber > 0) {
                BlueRun blueRun;
                WorkflowRun run;
                BlueChangeSetEntry entry = (BlueChangeSetEntry)changeSets.get(commitId);
                if (entry != null) {
                    return entry.getUrl();
                }
                if ((run = job.getBuildByNumber(--buildNumber)) == null || (blueRun = BlueRunFactory.getRun((Run)run, (Reachable)this.parent)) == null) continue;
                changeSets = blueRun.getChangeSet();
            }
        }
        return null;
    }

    public String getCauseOfBlockage() {
        for (Queue.Item i : Jenkins.getInstance().getQueue().getItems()) {
            ExecutorStepExecution.PlaceholderTask task;
            Run r;
            if (!(i.task instanceof ExecutorStepExecution.PlaceholderTask) || (r = (task = (ExecutorStepExecution.PlaceholderTask)i.task).runForDisplay()) == null || !r.equals(this.run)) continue;
            String cause = i.getCauseOfBlockage().getShortDescription();
            if (task.getCauseOfBlockage() != null) {
                cause = task.getCauseOfBlockage().getShortDescription();
            }
            return cause;
        }
        return null;
    }

    @Extension(ordinal=1.0)
    public static class FactoryImpl
    extends BlueRunFactory {
        public BlueRun getRun(Run run, Reachable parent, BlueOrganization organization) {
            if (run instanceof WorkflowRun) {
                return new PipelineRunImpl((WorkflowRun)run, parent, organization);
            }
            return null;
        }
    }
}

