/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.htmlpublisher;

import com.google.common.collect.Lists;
import htmlpublisher.HtmlPublisherTarget;
import hudson.Extension;
import hudson.model.Run;
import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.factory.BlueArtifactFactory;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.model.BlueArtifact;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HTMLArtifact
extends BlueArtifact {
    private final HtmlPublisherTarget.HTMLBuildAction action;

    public HTMLArtifact(HtmlPublisherTarget.HTMLBuildAction action, Link parent) {
        super(parent);
        this.action = action;
    }

    public String getName() {
        return this.action.getHTMLTarget().getReportName();
    }

    public String getPath() {
        return this.action.getHTMLTarget().getReportName();
    }

    public String getUrl() {
        return String.format("/%s%s", this.action.getOwner().getUrl(), this.action.getUrlName());
    }

    public long getSize() {
        return -1L;
    }

    public boolean isDownloadable() {
        return false;
    }

    @Extension
    public static class FactoryImpl
    extends BlueArtifactFactory {
        public Collection<BlueArtifact> getArtifacts(Run<?, ?> run, Reachable parent) {
            List actions = run.getActions(HtmlPublisherTarget.HTMLBuildAction.class);
            if (actions.isEmpty()) {
                return null;
            }
            ArrayList foundArtifacts = Lists.newArrayList();
            for (HtmlPublisherTarget.HTMLBuildAction action : actions) {
                foundArtifacts.add(new HTMLArtifact(action, parent.getLink()));
            }
            return foundArtifacts;
        }
    }
}

