/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;

public class PipelineStepVisitor
extends StandardChunkVisitor {
    private final FlowNode node;
    private final WorkflowRun run;
    private final ArrayDeque<FlowNodeWrapper> steps = new ArrayDeque();
    private final Map<String, FlowNodeWrapper> stepMap = new HashMap<String, FlowNodeWrapper>();
    private boolean stepCollectionCompleted = false;
    private boolean inStageScope;

    public PipelineStepVisitor(WorkflowRun run, @Nullable FlowNode node) {
        this.node = node;
        this.run = run;
    }

    public void parallelBranchStart(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchStartNode, @Nonnull ForkScanner scanner) {
        if (this.stepCollectionCompleted) {
            return;
        }
        if (this.node != null && branchStartNode.equals((Object)this.node)) {
            this.stepCollectionCompleted = true;
        } else if (this.node != null && PipelineNodeUtil.isParallelBranch(this.node) && !branchStartNode.equals((Object)this.node)) {
            this.resetSteps();
        }
    }

    public void parallelBranchEnd(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchEndNode, @Nonnull ForkScanner scanner) {
        if (!this.stepCollectionCompleted && this.node != null && PipelineNodeUtil.isParallelBranch(this.node) && branchEndNode instanceof StepEndNode) {
            this.resetSteps();
        }
    }

    public void chunkEnd(@Nonnull FlowNode endNode, @CheckForNull FlowNode afterChunk, @Nonnull ForkScanner scanner) {
        super.chunkEnd(endNode, afterChunk, scanner);
        if (this.node != null && endNode instanceof StepEndNode && ((StepStartNode)((StepEndNode)endNode).getStartNode()).equals((Object)this.node)) {
            this.stepCollectionCompleted = false;
            this.inStageScope = true;
        }
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterChunk, scanner);
        }
    }

    protected void handleChunkDone(@Nonnull MemoryFlowChunk chunk) {
        if (this.stepCollectionCompleted) {
            return;
        }
        if (this.node != null && chunk.getFirstNode().equals((Object)this.node)) {
            this.stepCollectionCompleted = true;
            this.inStageScope = false;
        }
        if (this.node != null && PipelineNodeUtil.isStage(this.node) && !this.inStageScope && !chunk.getFirstNode().equals((Object)this.node)) {
            this.resetSteps();
        }
    }

    public void atomNode(@CheckForNull FlowNode before, @Nonnull FlowNode atomNode, @CheckForNull FlowNode after, @Nonnull ForkScanner scan) {
        if (this.stepCollectionCompleted) {
            return;
        }
        if (atomNode instanceof StepAtomNode) {
            if (this.stepMap.get(atomNode.getId()) != null) {
                return;
            }
            long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
            this.chunk.setPauseTimeMillis(this.chunk.getPauseTimeMillis() + pause);
            TimingInfo times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)pause, (FlowNode)atomNode, (FlowNode)atomNode, (FlowNode)after);
            if (times == null) {
                times = new TimingInfo();
            }
            FlowNodeWrapper node = new FlowNodeWrapper(atomNode, new NodeRunStatus(atomNode), times);
            this.steps.push(node);
            this.stepMap.put(node.getId(), node);
        }
    }

    public List<FlowNodeWrapper> getSteps() {
        return new ArrayList<FlowNodeWrapper>(this.steps);
    }

    public FlowNodeWrapper getStep(String id) {
        return this.stepMap.get(id);
    }

    private void resetSteps() {
        this.steps.clear();
        this.stepMap.clear();
    }
}

