/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import io.jenkins.blueocean.service.embedded.rest.LogResource;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.LogAction;

public class PipelineStepImpl
extends BluePipelineStep {
    private final FlowNodeWrapper node;
    private final Link self;

    public PipelineStepImpl(FlowNodeWrapper node, Link parent) {
        assert (node != null);
        this.self = parent.rel(node.getId());
        this.node = node;
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return this.node.getNode().getDisplayName();
    }

    public BlueRun.BlueRunResult getResult() {
        return this.node.getStatus().getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.node.getStatus().getState();
    }

    public Date getStartTime() {
        return new Date(this.node.getTiming().getStartTimeMillis());
    }

    public Long getDurationInMillis() {
        return this.node.getTiming().getTotalDurationMillis();
    }

    public Object getLog() {
        if (PipelineNodeUtil.isLoggable.apply((Object)this.node.getNode())) {
            return new LogResource(((LogAction)this.node.getNode().getAction(LogAction.class)).getLogText());
        }
        return null;
    }

    public Collection<BlueActionProxy> getActions() {
        return PipelineImpl.getActionProxies((List)this.node.getNode().getActions(), (Reachable)this);
    }

    public Link getLink() {
        return this.self;
    }
}

