/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.base.Predicate;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.actions.ThreadNameAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepStartNode;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.steps.FlowInterruptedException;

public class PipelineNodeUtil {
    public static Predicate<FlowNode> isLoggable = new Predicate<FlowNode>(){

        public boolean apply(@Nullable FlowNode input) {
            if (input == null) {
                return false;
            }
            return input.getAction(LogAction.class) != null;
        }
    };

    public static BlueRun.BlueRunResult getStatus(ErrorAction errorAction) {
        if (errorAction == null) {
            return BlueRun.BlueRunResult.SUCCESS;
        }
        return PipelineNodeUtil.getStatus(errorAction.getError());
    }

    public static BlueRun.BlueRunResult getStatus(Throwable error) {
        if (error instanceof FlowInterruptedException) {
            return BlueRun.BlueRunResult.ABORTED;
        }
        return BlueRun.BlueRunResult.FAILURE;
    }

    public static NodeRunStatus getStatus(WorkflowRun run) {
        BlueRun.BlueRunState state;
        BlueRun.BlueRunResult result;
        FlowExecution execution = run.getExecution();
        if (execution == null) {
            result = BlueRun.BlueRunResult.NOT_BUILT;
            state = BlueRun.BlueRunState.QUEUED;
        } else if (execution.getCauseOfFailure() != null) {
            result = PipelineNodeUtil.getStatus(execution.getCauseOfFailure());
            state = BlueRun.BlueRunState.FINISHED;
        } else if (execution.isComplete()) {
            result = BlueRun.BlueRunResult.SUCCESS;
            state = BlueRun.BlueRunState.FINISHED;
        } else {
            result = BlueRun.BlueRunResult.UNKNOWN;
            state = BlueRun.BlueRunState.RUNNING;
        }
        return new NodeRunStatus(result, state);
    }

    public static String getDisplayName(FlowNode node) {
        return node.getAction(ThreadNameAction.class) != null ? ((ThreadNameAction)node.getAction(ThreadNameAction.class)).getThreadName() : node.getDisplayName();
    }

    public static boolean isStage(FlowNode node) {
        return node != null && (node.getAction(StageAction.class) != null || node.getAction(LabelAction.class) != null && node.getAction(ThreadNameAction.class) == null);
    }

    public static boolean isParallelBranch(FlowNode node) {
        return node != null && node.getAction(LabelAction.class) != null && node.getAction(ThreadNameAction.class) != null;
    }

    public static boolean isNestedInParallel(List<FlowNode> sortedNodes, FlowNode node) {
        FlowNode p = PipelineNodeUtil.getClosestEnclosingParallelBranch(sortedNodes, node, node.getParents());
        return PipelineNodeUtil.isInBlock(p, PipelineNodeUtil.getStepEndNode(sortedNodes, p), node);
    }

    private static FlowNode getClosestEnclosingParallelBranch(List<FlowNode> sortedNodes, FlowNode node, List<FlowNode> parents) {
        Iterator<FlowNode> iterator = parents.iterator();
        if (iterator.hasNext()) {
            FlowNode n = iterator.next();
            if (PipelineNodeUtil.isParallelBranch(n) && PipelineNodeUtil.isInBlock(n, PipelineNodeUtil.getStepEndNode(sortedNodes, n), node)) {
                return n;
            }
            return PipelineNodeUtil.getClosestEnclosingParallelBranch(sortedNodes, node, n.getParents());
        }
        return null;
    }

    public static FlowNode getStepEndNode(List<FlowNode> sortedNodes, FlowNode startNode) {
        for (int i = sortedNodes.size() - 1; i >= 0; --i) {
            StepEndNode endNode;
            FlowNode n = sortedNodes.get(i);
            if (!(n instanceof StepEndNode) || !((StepStartNode)(endNode = (StepEndNode)n).getStartNode()).equals((Object)startNode)) continue;
            return endNode;
        }
        return null;
    }

    public static FlowNode getEndNode(List<FlowNode> sortedNodes, FlowNode startNode) {
        for (int i = sortedNodes.size() - 1; i >= 0; --i) {
            StepAtomNode endNode;
            FlowNode n = sortedNodes.get(i);
            if (!(n instanceof StepAtomNode) || !(endNode = (StepAtomNode)n).equals((Object)startNode)) continue;
            return endNode;
        }
        return null;
    }

    public static boolean isInBlock(FlowNode startNode, FlowNode endNode, FlowNode c) {
        return PipelineNodeUtil.isChildOf(startNode, c) && PipelineNodeUtil.isChildOf(c, endNode);
    }

    public static boolean isChildOf(FlowNode parent, FlowNode child) {
        if (child == null) {
            return false;
        }
        Iterator iterator = child.getParents().iterator();
        if (iterator.hasNext()) {
            FlowNode p = (FlowNode)iterator.next();
            if (p.equals((Object)parent)) {
                return true;
            }
            return PipelineNodeUtil.isChildOf(parent, p);
        }
        return false;
    }

    public static boolean isBranchNestedInBranch(FlowNode node) {
        for (FlowNode n : node.getParents()) {
            if (PipelineNodeUtil.isParallelBranch(node)) {
                return true;
            }
            PipelineNodeUtil.isBranchNestedInBranch(n);
        }
        return false;
    }
}

