/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.Reachable;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepContainerImpl;
import io.jenkins.blueocean.rest.model.BlueActionProxy;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStepContainer;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineNodeImpl
extends BluePipelineNode {
    final FlowNodeWrapper node;
    private final List<BluePipelineNode.Edge> edges;
    private final Long durationInMillis;
    private final NodeRunStatus status;
    private final Link self;
    private final WorkflowRun run;

    public PipelineNodeImpl(FlowNodeWrapper node, Link parentLink, WorkflowRun run) {
        this.node = node;
        this.run = run;
        this.edges = this.buildEdges(node.edges);
        this.status = node.getStatus();
        this.durationInMillis = node.getTiming().getTotalDurationMillis();
        this.self = parentLink.rel(node.getId());
    }

    public String getId() {
        return this.node.getId();
    }

    public String getDisplayName() {
        return PipelineNodeUtil.getDisplayName(this.node.getNode());
    }

    public BlueRun.BlueRunResult getResult() {
        return this.status.getResult();
    }

    public BlueRun.BlueRunState getStateObj() {
        return this.status.getState();
    }

    public Date getStartTime() {
        long nodeTime = this.node.getTiming().getStartTimeMillis();
        if (nodeTime == 0L) {
            return null;
        }
        return new Date(nodeTime);
    }

    public List<BluePipelineNode.Edge> getEdges() {
        return this.edges;
    }

    public Long getDurationInMillis() {
        return this.durationInMillis;
    }

    public Object getLog() {
        return null;
    }

    public BluePipelineStepContainer getSteps() {
        return new PipelineStepContainerImpl(this.node, this.self, this.run);
    }

    public Link getLink() {
        return this.self;
    }

    public Collection<BlueActionProxy> getActions() {
        return PipelineImpl.getActionProxies((List)this.node.getNode().getAllActions(), (Reachable)this);
    }

    private List<BluePipelineNode.Edge> buildEdges(List<String> nodes) {
        ArrayList<BluePipelineNode.Edge> edges = new ArrayList<BluePipelineNode.Edge>();
        if (!nodes.isEmpty()) {
            for (String id : nodes) {
                edges.add(new EdgeImpl(id));
            }
        }
        return edges;
    }

    public static class EdgeImpl
    extends BluePipelineNode.Edge {
        private final String id;

        public EdgeImpl(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

