/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.base.Predicate;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepVisitor;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.graph.BlockEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.graphanalysis.ChunkFinder;
import org.jenkinsci.plugins.workflow.graphanalysis.DepthFirstScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.ForkScanner;
import org.jenkinsci.plugins.workflow.graphanalysis.MemoryFlowChunk;
import org.jenkinsci.plugins.workflow.graphanalysis.SimpleChunkVisitor;
import org.jenkinsci.plugins.workflow.graphanalysis.StandardChunkVisitor;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.GenericStatus;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StageChunkFinder;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.StatusAndTiming;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;
import org.jenkinsci.plugins.workflow.support.actions.PauseAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineNodeGraphVisitor
extends StandardChunkVisitor
implements NodeGraphBuilder {
    private final WorkflowRun run;
    public final Map<FlowNodeWrapper, List<FlowNodeWrapper>> parentToChildrenMap = new LinkedHashMap<FlowNodeWrapper, List<FlowNodeWrapper>>();
    private final ArrayDeque<FlowNodeWrapper> parallelBranches = new ArrayDeque();
    public final ArrayDeque<FlowNodeWrapper> nodes = new ArrayDeque();
    private FlowNode firstExecuted = null;
    private FlowNodeWrapper nextStage;
    private FlowNode parallelEnd;
    public final Map<String, FlowNodeWrapper> nodeMap = new LinkedHashMap<String, FlowNodeWrapper>();
    private static final Logger logger = LoggerFactory.getLogger(PipelineNodeGraphVisitor.class);
    private static final boolean isNodeVisitorDumpEnabled = Boolean.getBoolean("NODE-DUMP-ENABLED");
    private final Stack<FlowNode> nestedStages = new Stack();
    private final Stack<FlowNode> nestedbranches = new Stack();

    public PipelineNodeGraphVisitor(WorkflowRun run) {
        this.run = run;
        if (run.getExecution() != null) {
            ForkScanner.visitSimpleChunks((Collection)run.getExecution().getCurrentHeads(), (SimpleChunkVisitor)this, (ChunkFinder)new StageChunkFinder());
        }
    }

    public void chunkStart(@Nonnull FlowNode startNode, @CheckForNull FlowNode beforeBlock, @Nonnull ForkScanner scanner) {
        super.chunkStart(startNode, beforeBlock, scanner);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("chunkStart=> id: %s, name: %s, function: %s", startNode.getId(), startNode.getDisplayName(), startNode.getDisplayFunctionName()));
        }
        if (NotExecutedNodeAction.isExecuted((FlowNode)startNode)) {
            this.firstExecuted = startNode;
        }
    }

    public void chunkEnd(@Nonnull FlowNode endNode, @CheckForNull FlowNode afterBlock, @Nonnull ForkScanner scanner) {
        super.chunkEnd(endNode, afterBlock, scanner);
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("chunkEnd=> id: %s, name: %s, function: %s, type:%s", endNode.getId(), endNode.getDisplayName(), endNode.getDisplayFunctionName(), endNode.getClass()));
        }
        if (isNodeVisitorDumpEnabled && endNode instanceof StepEndNode) {
            this.dump("\tStartNode: " + ((StepEndNode)endNode).getStartNode());
        }
        if (endNode instanceof StepEndNode && PipelineNodeUtil.isStage((FlowNode)((StepEndNode)endNode).getStartNode())) {
            this.nestedStages.push(endNode);
        }
        this.firstExecuted = null;
        if (!(endNode instanceof BlockEndNode)) {
            this.atomNode(null, endNode, afterBlock, scanner);
        }
    }

    public void parallelStart(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelStart=> id: %s, name: %s, function: %s", parallelStartNode.getId(), parallelStartNode.getDisplayName(), parallelStartNode.getDisplayFunctionName()));
            this.dump(String.format("\tbranch=> id: %s, name: %s, function: %s", branchNode.getId(), branchNode.getDisplayName(), branchNode.getDisplayFunctionName()));
        }
        FlowNodeWrapper[] sortedBranches = this.parallelBranches.toArray(new FlowNodeWrapper[this.parallelBranches.size()]);
        Arrays.sort(sortedBranches, new Comparator<FlowNodeWrapper>(){

            @Override
            public int compare(FlowNodeWrapper o1, FlowNodeWrapper o2) {
                return o1.getDisplayName().compareTo(o2.getDisplayName());
            }
        });
        this.parallelBranches.clear();
        for (int i = 0; i < sortedBranches.length; ++i) {
            this.parallelBranches.push(sortedBranches[i]);
        }
        for (FlowNodeWrapper p : this.parallelBranches) {
            this.nodes.push(p);
            this.nodeMap.put(p.getId(), p);
        }
        this.parallelEnd = null;
    }

    public void parallelEnd(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode parallelEndNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelEnd=> id: %s, name: %s, function: %s", parallelEndNode.getId(), parallelEndNode.getDisplayName(), parallelEndNode.getDisplayFunctionName()));
        }
        this.parallelEnd = parallelEndNode;
    }

    public void parallelBranchStart(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchStartNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelBranchStart=> id: %s, name: %s, function: %s", branchStartNode.getId(), branchStartNode.getDisplayName(), branchStartNode.getDisplayFunctionName()));
        }
        if (this.nestedbranches.size() > 1) {
            this.nestedbranches.pop();
            if (this.nestedbranches.size() > 1) {
                return;
            }
        }
        FlowNode endNode = this.nestedbranches.pop();
        TimingInfo times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)this.chunk.getPauseTimeMillis(), (FlowNode)branchStartNode, (FlowNode)endNode, (FlowNode)this.chunk.getNodeAfter());
        if (times == null) {
            times = new TimingInfo();
        }
        GenericStatus status = StatusAndTiming.computeChunkStatus((WorkflowRun)this.run, (FlowNode)parallelStartNode, (FlowNode)branchStartNode, (FlowNode)endNode, (FlowNode)this.parallelEnd);
        FlowNodeWrapper branch = new FlowNodeWrapper(branchStartNode, new NodeRunStatus(status), times);
        if (this.nextStage != null) {
            branch.addEdge(this.nextStage.getId());
        }
        this.parallelBranches.push(branch);
    }

    public void parallelBranchEnd(@Nonnull FlowNode parallelStartNode, @Nonnull FlowNode branchEndNode, @Nonnull ForkScanner scanner) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("parallelBranchEnd=> id: %s, name: %s, function: %s, type: %s", branchEndNode.getId(), branchEndNode.getDisplayName(), branchEndNode.getDisplayFunctionName(), branchEndNode.getClass()));
        }
        this.nestedbranches.push(branchEndNode);
    }

    protected void handleChunkDone(@Nonnull MemoryFlowChunk chunk) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("handleChunkDone=> id: %s, name: %s, function: %s", chunk.getFirstNode().getId(), chunk.getFirstNode().getDisplayName(), chunk.getFirstNode().getDisplayFunctionName()));
        }
        if (!this.nestedStages.empty()) {
            this.nestedStages.pop();
            if (!this.nestedStages.empty()) {
                return;
            }
        }
        TimingInfo times = null;
        if (this.firstExecuted != null) {
            times = StatusAndTiming.computeChunkTiming((WorkflowRun)this.run, (long)chunk.getPauseTimeMillis(), (FlowNode)this.firstExecuted, (FlowNode)chunk.getLastNode(), (FlowNode)chunk.getNodeAfter());
        }
        if (times == null) {
            times = new TimingInfo();
        }
        GenericStatus status = this.firstExecuted == null ? GenericStatus.NOT_EXECUTED : StatusAndTiming.computeChunkStatus((WorkflowRun)this.run, (FlowNode)chunk.getNodeBefore(), (FlowNode)this.firstExecuted, (FlowNode)chunk.getLastNode(), (FlowNode)chunk.getNodeAfter());
        FlowNodeWrapper stage = new FlowNodeWrapper(chunk.getFirstNode(), new NodeRunStatus(status), times);
        this.nodes.push(stage);
        this.nodeMap.put(stage.getId(), stage);
        if (!this.parallelBranches.isEmpty()) {
            Iterator<FlowNodeWrapper> branches = this.parallelBranches.descendingIterator();
            while (branches.hasNext()) {
                FlowNodeWrapper p = branches.next();
                p.addParent(stage);
                stage.addEdge(p.getId());
            }
            this.parallelBranches.clear();
        } else if (this.nextStage != null) {
            this.nextStage.addParent(stage);
            stage.addEdge(this.nextStage.getId());
        }
        this.nextStage = stage;
    }

    protected void resetChunk(@Nonnull MemoryFlowChunk chunk) {
        super.resetChunk(chunk);
        this.firstExecuted = null;
    }

    public void atomNode(@CheckForNull FlowNode before, @Nonnull FlowNode atomNode, @CheckForNull FlowNode after, @Nonnull ForkScanner scan) {
        if (isNodeVisitorDumpEnabled) {
            this.dump(String.format("atomNode=> id: %s, name: %s, function: %s, type: %s", atomNode.getId(), atomNode.getDisplayName(), atomNode.getDisplayFunctionName(), atomNode.getClass()));
        }
        if (NotExecutedNodeAction.isExecuted((FlowNode)atomNode)) {
            this.firstExecuted = atomNode;
        }
        long pause = PauseAction.getPauseDuration((FlowNode)atomNode);
        this.chunk.setPauseTimeMillis(this.chunk.getPauseTimeMillis() + pause);
    }

    private void dump(String str) {
        logger.debug(str);
    }

    @Override
    public List<FlowNodeWrapper> getPipelineNodes() {
        return new ArrayList<FlowNodeWrapper>(this.nodes);
    }

    @Override
    public List<BluePipelineNode> getPipelineNodes(Link parent) {
        ArrayList<BluePipelineNode> nodes = new ArrayList<BluePipelineNode>();
        for (FlowNodeWrapper n : this.nodes) {
            nodes.add(new PipelineNodeImpl(n, parent, this.run));
        }
        return nodes;
    }

    @Override
    public List<BluePipelineStep> getPipelineNodeSteps(final String nodeId, Link parent) {
        DepthFirstScanner depthFirstScanner = new DepthFirstScanner();
        if (this.run.getExecution() == null) {
            logger.debug(String.format("Pipeline %s, runid %s  has null execution", ((WorkflowJob)this.run.getParent()).getName(), this.run.getId()));
            return Collections.emptyList();
        }
        FlowNode n = depthFirstScanner.findFirstMatch((Collection)this.run.getExecution().getCurrentHeads(), (Predicate)new Predicate<FlowNode>(){

            public boolean apply(@Nullable FlowNode input) {
                return input != null && input.getId().equals(nodeId) && (PipelineNodeUtil.isStage(input) || PipelineNodeUtil.isParallelBranch(input));
            }
        });
        if (n == null) {
            return Collections.emptyList();
        }
        PipelineStepVisitor visitor = new PipelineStepVisitor(this.run, n);
        ForkScanner.visitSimpleChunks((Collection)this.run.getExecution().getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
        ArrayList<BluePipelineStep> steps = new ArrayList<BluePipelineStep>();
        for (FlowNodeWrapper node : visitor.getSteps()) {
            steps.add(new PipelineStepImpl(node, parent));
        }
        return steps;
    }

    @Override
    public List<BluePipelineStep> getPipelineNodeSteps(Link parent) {
        if (this.run.getExecution() == null) {
            return Collections.emptyList();
        }
        PipelineStepVisitor visitor = new PipelineStepVisitor(this.run, null);
        ForkScanner.visitSimpleChunks((Collection)this.run.getExecution().getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
        ArrayList<BluePipelineStep> steps = new ArrayList<BluePipelineStep>();
        for (FlowNodeWrapper node : visitor.getSteps()) {
            steps.add(new PipelineStepImpl(node, parent));
        }
        return steps;
    }

    @Override
    public BluePipelineStep getPipelineNodeStep(String id, Link parent) {
        if (this.run.getExecution() == null) {
            return null;
        }
        PipelineStepVisitor visitor = new PipelineStepVisitor(this.run, null);
        ForkScanner.visitSimpleChunks((Collection)this.run.getExecution().getCurrentHeads(), (SimpleChunkVisitor)visitor, (ChunkFinder)new StageChunkFinder());
        FlowNodeWrapper node = visitor.getStep(id);
        if (node == null) {
            return null;
        }
        return new PipelineStepImpl(node, parent);
    }

    @Override
    public List<BluePipelineNode> union(List<FlowNodeWrapper> that, Link parent) {
        int futureNodeSize;
        ArrayList<FlowNodeWrapper> currentNodes = new ArrayList<FlowNodeWrapper>(this.nodes);
        int currentNodeSize = this.nodes.size();
        if (currentNodeSize < (futureNodeSize = that.size())) {
            for (int i = currentNodeSize; i < futureNodeSize; ++i) {
                FlowNodeWrapper futureNode = that.get(i);
                if (currentNodeSize > 0 && i == currentNodeSize) {
                    FlowNodeWrapper stage;
                    FlowNodeWrapper latestNode = (FlowNodeWrapper)currentNodes.get(i - 1);
                    if (latestNode.type == FlowNodeWrapper.NodeType.STAGE) {
                        latestNode.addEdge(futureNode.getId());
                    } else if (latestNode.type == FlowNodeWrapper.NodeType.PARALLEL && (stage = latestNode.getFirstParent()) != null) {
                        for (String id : stage.edges) {
                            FlowNodeWrapper node = this.nodeMap.get(id);
                            if (node == null) continue;
                            node.addEdge(futureNode.getId());
                        }
                    }
                }
                FlowNodeWrapper n = new FlowNodeWrapper(futureNode.getNode(), new NodeRunStatus(null, null), new TimingInfo());
                n.addEdges(futureNode.edges);
                n.addParents(futureNode.getParents());
                currentNodes.add(n);
            }
        }
        ArrayList<BluePipelineNode> newNodes = new ArrayList<BluePipelineNode>();
        for (FlowNodeWrapper n : currentNodes) {
            newNodes.add(new PipelineNodeImpl(n, parent, this.run));
        }
        return newNodes;
    }
}

