/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.collect.Iterables;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.FlowNodeWrapper;
import io.jenkins.blueocean.rest.impl.pipeline.NodeGraphBuilder;
import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineStepImpl;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BluePipelineStep;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jenkinsci.plugins.workflow.actions.LabelAction;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.StageAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;

public class PipelineNodeGraphBuilder
implements NodeGraphBuilder {
    private final List<FlowNode> sortedNodes;
    private final WorkflowRun run;
    private final Map<FlowNode, List<FlowNode>> parentToChildrenMap = new LinkedHashMap<FlowNode, List<FlowNode>>();
    private final Map<FlowNode, NodeRunStatus> nodeStatusMap = new LinkedHashMap<FlowNode, NodeRunStatus>();

    public PipelineNodeGraphBuilder(WorkflowRun run) {
        this.run = run;
        TreeSet<FlowNode> nodeTreeSet = new TreeSet<FlowNode>(new Comparator<FlowNode>(){

            @Override
            public int compare(FlowNode node1, FlowNode node2) {
                return Integer.compare(this.parseIota(node1), this.parseIota(node2));
            }

            private int parseIota(FlowNode node) {
                try {
                    return Integer.parseInt(node.getId());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        if (run.getExecution() != null) {
            Iterables.addAll(nodeTreeSet, (Iterable)new FlowGraphWalker(run.getExecution()));
        }
        this.sortedNodes = Collections.unmodifiableList(new ArrayList<FlowNode>(nodeTreeSet));
        this.build();
    }

    private void build() {
        FlowNode previousStage = null;
        FlowNode previousBranch = null;
        int count = 0;
        for (FlowNode node : this.sortedNodes) {
            FlowNode endNode;
            if (!PipelineNodeUtil.isStage(node) && !PipelineNodeUtil.isParallelBranch(node)) continue;
            boolean nestedInParallel = PipelineNodeUtil.isNestedInParallel(this.sortedNodes, node);
            if (PipelineNodeUtil.isStage(node) && !nestedInParallel) {
                this.addChild(node, null);
                if (previousBranch != null) {
                    List<FlowNode> branches = this.parentToChildrenMap.get(previousStage);
                    for (FlowNode n : branches) {
                        this.addChild(n, node);
                    }
                    previousBranch = null;
                } else if (previousStage != null) {
                    this.addChild(previousStage, node);
                } else {
                    this.addChild(node, null);
                }
                if (node.getAction(LabelAction.class) != null && node.getAction(StageAction.class) == null) {
                    endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, node);
                    if (endNode == null) {
                        endNode = PipelineNodeUtil.getEndNode(this.sortedNodes, node);
                    }
                    if (endNode != null) {
                        this.nodeStatusMap.put(node, new NodeRunStatus(endNode));
                    }
                } else if (previousStage != null) {
                    this.nodeStatusMap.put(previousStage, new NodeRunStatus(this.sortedNodes.get(count - 1)));
                }
                previousStage = node;
            } else if (PipelineNodeUtil.isParallelBranch(node) && !nestedInParallel) {
                this.addChild(node, null);
                if (previousStage != null) {
                    this.addChild(previousStage, node);
                }
                if ((endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, node)) != null) {
                    this.nodeStatusMap.put(node, new NodeRunStatus(endNode));
                } else {
                    this.nodeStatusMap.put(node, new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.RUNNING));
                }
                previousBranch = node;
            }
            ++count;
        }
        int size = this.parentToChildrenMap.keySet().size();
        if (size > 0) {
            NodeRunStatus runStatus = PipelineNodeUtil.getStatus(this.run);
            FlowNode lastNode = this.getLastStageNode();
            this.nodeStatusMap.put(lastNode, runStatus);
        }
    }

    public FlowNode getNodeById(String id) {
        for (FlowNode node : this.sortedNodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    public List<FlowNode> getSteps(FlowNode node) {
        if (PipelineNodeUtil.isStage(node)) {
            return this.getStageSteps(node);
        }
        if (PipelineNodeUtil.isParallelBranch(node)) {
            return this.getParallelBranchSteps(node);
        }
        return Collections.emptyList();
    }

    public List<FlowNode> getStageSteps(FlowNode p) {
        ArrayList<FlowNode> steps = new ArrayList<FlowNode>();
        int i = this.sortedNodes.indexOf(p);
        if (i >= 0 && PipelineNodeUtil.isStage(p)) {
            FlowNode c;
            FlowNode end = PipelineNodeUtil.getStepEndNode(this.sortedNodes, p);
            for (int j = i + 1; j < this.sortedNodes.size() && (!PipelineNodeUtil.isStage(c = this.sortedNodes.get(j)) || PipelineNodeUtil.isInBlock(p, end, c)); ++j) {
                if (!(c instanceof StepAtomNode)) continue;
                steps.add(c);
            }
        }
        return steps;
    }

    public List<FlowNode> getAllSteps() {
        ArrayList<FlowNode> steps = new ArrayList<FlowNode>();
        for (FlowNode c : this.sortedNodes) {
            if (!(c instanceof StepAtomNode) || PipelineNodeUtil.isStage(c)) continue;
            steps.add(c);
        }
        return steps;
    }

    public List<FlowNode> getParallelBranchSteps(FlowNode p) {
        ArrayList<FlowNode> steps = new ArrayList<FlowNode>();
        int i = this.sortedNodes.indexOf(p);
        FlowNode prev = p;
        if (i >= 0 && PipelineNodeUtil.isParallelBranch(p)) {
            FlowNode end = PipelineNodeUtil.getStepEndNode(this.sortedNodes, p);
            for (int j = i + 1; j < this.sortedNodes.size(); ++j) {
                FlowNode c = this.sortedNodes.get(j);
                if (c.equals((Object)end)) {
                    this.nodeStatusMap.put(p, new NodeRunStatus(end));
                    break;
                }
                if (PipelineNodeUtil.isParallelBranch(c) || !PipelineNodeUtil.isInBlock(p, end, c) && !this.isParentOf(c, prev) || !(c instanceof StepAtomNode)) continue;
                steps.add(c);
                prev = c;
                FlowNode endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, c);
                if (endNode == null) continue;
                this.nodeStatusMap.put(c, new NodeRunStatus(endNode));
            }
        }
        return steps;
    }

    private boolean isParentOf(FlowNode node, FlowNode child) {
        for (FlowNode n : node.getParents()) {
            if (!child.equals((Object)n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<FlowNodeWrapper> getPipelineNodes() {
        ArrayList<FlowNodeWrapper> nodes = new ArrayList<FlowNodeWrapper>();
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            NodeRunStatus status = this.nodeStatusMap.get(n);
            if (!this.isExecuted(n)) {
                status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.QUEUED);
            } else if (status == null) {
                status = this.getEffectiveBranchStatus(n);
            }
            long durationInMillis = 0L;
            long startTime = TimingAction.getStartTime((FlowNode)n);
            if (status.state == BlueRun.BlueRunState.FINISHED) {
                durationInMillis = this.getDurationInMillis(n);
            } else if (status.state == BlueRun.BlueRunState.RUNNING) {
                durationInMillis = System.currentTimeMillis() - TimingAction.getStartTime((FlowNode)n);
            }
            FlowNodeWrapper wrapper = new FlowNodeWrapper(n, status, new TimingInfo(durationInMillis, 0L, startTime));
            for (FlowNode c : this.parentToChildrenMap.get(n)) {
                wrapper.addEdge(c.getId());
            }
            nodes.add(wrapper);
        }
        return nodes;
    }

    @Override
    public List<BluePipelineNode> getPipelineNodes(Link parentLink) {
        ArrayList<BluePipelineNode> nodes = new ArrayList<BluePipelineNode>();
        for (FlowNodeWrapper n : this.getPipelineNodes()) {
            nodes.add(new PipelineNodeImpl(n, parentLink, this.run));
        }
        return nodes;
    }

    @Override
    public List<BluePipelineStep> getPipelineNodeSteps(String nodeId, Link parent) {
        ArrayList<BluePipelineStep> steps = new ArrayList<BluePipelineStep>();
        ArrayList<FlowNode> flowNodes = new ArrayList<FlowNode>();
        if (nodeId == null) {
            flowNodes.addAll(this.getAllSteps());
        } else {
            flowNodes.addAll(this.getSteps(this.getNodeById(nodeId)));
        }
        for (FlowNode node : flowNodes) {
            steps.add(new PipelineStepImpl(new FlowNodeWrapper(node, new NodeRunStatus(node), new TimingInfo(this.getDurationInMillis(node), 0L, 0L)), parent));
        }
        return steps;
    }

    @Override
    public List<BluePipelineStep> getPipelineNodeSteps(Link parent) {
        return this.getPipelineNodeSteps(null, parent);
    }

    @Override
    public BluePipelineStep getPipelineNodeStep(String id, Link parent) {
        for (BluePipelineStep step : this.getPipelineNodeSteps(parent)) {
            if (!step.getId().equals(id)) continue;
            return step;
        }
        return null;
    }

    @Override
    public List<BluePipelineNode> union(List<FlowNodeWrapper> futureNodes, Link parentLink) {
        List<FlowNodeWrapper> currentNodes = this.getPipelineNodes();
        int currentNodeSize = currentNodes.size();
        if (currentNodeSize < futureNodes.size()) {
            for (int i = currentNodeSize; i < futureNodes.size(); ++i) {
                FlowNodeWrapper futureNode = futureNodes.get(i);
                if (currentNodeSize > 0 && i == currentNodeSize) {
                    FlowNode parent;
                    FlowNodeWrapper latestNode = currentNodes.get(currentNodeSize - 1);
                    if (PipelineNodeUtil.isStage(latestNode.getNode())) {
                        this.addChild(latestNode.getNode(), futureNode.getNode());
                    } else if (PipelineNodeUtil.isParallelBranch(latestNode.getNode()) && (parent = this.getParentStageOfBranch(latestNode.getNode())) != null) {
                        List<FlowNode> children = this.parentToChildrenMap.get(parent);
                        for (FlowNode c : children) {
                            if (!PipelineNodeUtil.isParallelBranch(c)) continue;
                            for (FlowNodeWrapper f : currentNodes) {
                                if (!f.getNode().equals((Object)c)) continue;
                                f.addEdge(futureNode.getId());
                            }
                        }
                    }
                }
                FlowNodeWrapper n = new FlowNodeWrapper(futureNode.getNode(), new NodeRunStatus(null, null), new TimingInfo());
                n.addEdges(futureNode.edges);
                n.addParents(futureNode.getParents());
                currentNodes.add(n);
            }
        }
        ArrayList<BluePipelineNode> newNodes = new ArrayList<BluePipelineNode>();
        for (FlowNodeWrapper n : currentNodes) {
            newNodes.add(new PipelineNodeImpl(n, parentLink, this.run));
        }
        return newNodes;
    }

    public List<FlowNode> getChildren(FlowNode parent) {
        return this.parentToChildrenMap.get(parent);
    }

    public long getDurationInMillis(FlowNode node) {
        int i;
        long startTime = TimingAction.getStartTime((FlowNode)node);
        if (startTime == 0L) {
            return 0L;
        }
        if (PipelineNodeUtil.isStage(node)) {
            boolean lookForNextStage = false;
            for (FlowNode n : this.parentToChildrenMap.keySet()) {
                if (n.equals((Object)node)) {
                    lookForNextStage = true;
                    continue;
                }
                if (!lookForNextStage || !PipelineNodeUtil.isStage(n)) continue;
                return TimingAction.getStartTime((FlowNode)n) - startTime;
            }
        } else if (PipelineNodeUtil.isParallelBranch(node)) {
            FlowNode endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, node);
            if (endNode != null) {
                return TimingAction.getStartTime((FlowNode)endNode) - startTime;
            }
        } else if (node instanceof StepAtomNode && (i = this.sortedNodes.indexOf(node)) >= 0 && i + 1 < this.sortedNodes.size()) {
            return TimingAction.getStartTime((FlowNode)this.sortedNodes.get(i + 1)) - startTime;
        }
        return this.run.getExecution() != null && this.run.getExecution().isComplete() ? this.run.getDuration() + this.run.getStartTimeInMillis() - startTime : System.currentTimeMillis() - startTime;
    }

    private FlowNode getParentStageOfBranch(FlowNode node) {
        if (node.getParents().size() == 0) {
            return null;
        }
        FlowNode p = (FlowNode)node.getParents().get(0);
        if (PipelineNodeUtil.isStage(p)) {
            return p;
        }
        return this.getParentStageOfBranch(p);
    }

    private FlowNode getLastStageNode() {
        if (this.parentToChildrenMap.keySet().isEmpty()) {
            return null;
        }
        FlowNode node = null;
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isStage(n)) continue;
            node = n;
        }
        return node;
    }

    private NodeRunStatus getEffectiveBranchStatus(FlowNode n) {
        List<FlowNode> children = this.parentToChildrenMap.get(n);
        BlueRun.BlueRunResult result = BlueRun.BlueRunResult.SUCCESS;
        BlueRun.BlueRunState state = BlueRun.BlueRunState.FINISHED;
        boolean atLeastOneBranchDidNotSucceed = false;
        boolean atLeastOneBranchisUnknown = false;
        for (FlowNode c : children) {
            NodeRunStatus s;
            if (!PipelineNodeUtil.isParallelBranch(c) || (s = this.nodeStatusMap.get(c)) == null) continue;
            if (!atLeastOneBranchDidNotSucceed && s.getResult() == BlueRun.BlueRunResult.FAILURE || s.getResult() == BlueRun.BlueRunResult.UNSTABLE) {
                atLeastOneBranchDidNotSucceed = true;
                result = s.getResult();
            }
            if (s.getResult() == BlueRun.BlueRunResult.UNKNOWN) {
                atLeastOneBranchisUnknown = true;
            }
            if (s.getState() == BlueRun.BlueRunState.FINISHED || state == BlueRun.BlueRunState.RUNNING) continue;
            state = s.getState();
        }
        if (!atLeastOneBranchDidNotSucceed && atLeastOneBranchisUnknown) {
            result = BlueRun.BlueRunResult.UNKNOWN;
        }
        return new NodeRunStatus(result, state);
    }

    private boolean isExecuted(FlowNode node) {
        return NotExecutedNodeAction.isExecuted((FlowNode)node);
    }

    private List<FlowNode> addChild(FlowNode parent, FlowNode child) {
        List<FlowNode> children = this.parentToChildrenMap.get(parent);
        if (children == null) {
            children = new ArrayList<FlowNode>();
            this.parentToChildrenMap.put(parent, children);
        }
        if (child != null) {
            children.add(child);
        }
        return children;
    }

    public void dumpNodes(List<FlowNode> nodes) {
        for (FlowNode n : nodes) {
            System.out.println(String.format("id: %s, name: %s, startTime: %s, type: %s, parent: %s", n.getId(), n.getDisplayName(), TimingAction.getStartTime((FlowNode)n), n.getClass(), n.getParents().size() > 0 ? ((FlowNode)n.getParents().get(0)).getId() : null));
        }
    }

    public List<FlowNode> getSages() {
        ArrayList<FlowNode> stages = new ArrayList<FlowNode>();
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isStage(n)) continue;
            stages.add(n);
        }
        return stages;
    }

    public List<FlowNode> getParallelBranches() {
        ArrayList<FlowNode> parallel = new ArrayList<FlowNode>();
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isParallelBranch(n)) continue;
            parallel.add(n);
        }
        return parallel;
    }

    public static class InactiveFlowNodeWrapper
    extends FlowNode {
        private final FlowNode inactiveNode;

        public InactiveFlowNodeWrapper(FlowNode node) {
            super(node.getExecution(), node.getId(), new FlowNode[0]);
            this.inactiveNode = node;
        }

        protected String getTypeDisplayName() {
            return PipelineNodeUtil.getDisplayName(this.inactiveNode);
        }
    }
}

