/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import io.jenkins.blueocean.rest.impl.pipeline.NodeRunStatus;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.graph.AtomNode;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.pipelinegraphanalysis.TimingInfo;

public class FlowNodeWrapper {
    private final FlowNode node;
    private final NodeRunStatus status;
    private final TimingInfo timingInfo;
    public final List<String> edges = new ArrayList<String>();
    public final List<FlowNodeWrapper> steps = new ArrayList<FlowNodeWrapper>();
    public final NodeType type;
    private final String displayName;
    private List<FlowNodeWrapper> parents = new ArrayList<FlowNodeWrapper>();

    public FlowNodeWrapper(FlowNode node, NodeRunStatus status, TimingInfo timingInfo) {
        this.node = node;
        this.status = status;
        this.timingInfo = timingInfo;
        this.type = FlowNodeWrapper.getNodeType(node);
        this.displayName = PipelineNodeUtil.getDisplayName(node);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    private static NodeType getNodeType(FlowNode node) {
        if (PipelineNodeUtil.isStage(node)) {
            return NodeType.STAGE;
        }
        if (PipelineNodeUtil.isParallelBranch(node)) {
            return NodeType.PARALLEL;
        }
        if (node instanceof AtomNode) {
            return NodeType.STEP;
        }
        throw new IllegalArgumentException(String.format("Unknown FlowNode %s, type: %s", node.getId(), node.getClass()));
    }

    public NodeRunStatus getStatus() {
        return this.status;
    }

    public TimingInfo getTiming() {
        return this.timingInfo;
    }

    public String getId() {
        return this.node.getId();
    }

    public FlowNode getNode() {
        return this.node;
    }

    public void addEdge(String id) {
        this.edges.add(id);
    }

    public void addEdges(List<String> edges) {
        this.edges.addAll(edges);
    }

    public void addParent(FlowNodeWrapper parent) {
        this.parents.add(parent);
    }

    public void addParents(Collection<FlowNodeWrapper> parents) {
        parents.addAll(parents);
    }

    @Nullable
    public FlowNodeWrapper getFirstParent() {
        return this.parents.size() > 0 ? this.parents.get(0) : null;
    }

    public List<FlowNodeWrapper> getParents() {
        return this.parents;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FlowNodeWrapper)) {
            return false;
        }
        return this.node.equals(obj);
    }

    public FlowNode getFlowNode() {
        return this.node;
    }

    public int hashCode() {
        return this.node.hashCode();
    }

    public static enum NodeType {
        STAGE,
        PARALLEL,
        STEP;

    }
}

