/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.rest.impl.pipeline;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.jenkins.blueocean.rest.hal.Link;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeImpl;
import io.jenkins.blueocean.rest.impl.pipeline.PipelineNodeUtil;
import io.jenkins.blueocean.rest.model.BluePipelineNode;
import io.jenkins.blueocean.rest.model.BlueRun;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.jenkinsci.plugins.workflow.actions.NotExecutedNodeAction;
import org.jenkinsci.plugins.workflow.actions.TimingAction;
import org.jenkinsci.plugins.workflow.cps.nodes.StepAtomNode;
import org.jenkinsci.plugins.workflow.cps.nodes.StepEndNode;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineNodeGraphBuilder {
    private final List<FlowNode> sortedNodes;
    private final WorkflowRun run;
    private final Map<FlowNode, List<FlowNode>> parentToChildrenMap = new LinkedHashMap<FlowNode, List<FlowNode>>();
    private final Map<FlowNode, NodeRunStatus> nodeStatusMap = new LinkedHashMap<FlowNode, NodeRunStatus>();

    public PipelineNodeGraphBuilder(WorkflowRun run) {
        this.run = run;
        TreeSet<FlowNode> nodeTreeSet = new TreeSet<FlowNode>(new Comparator<FlowNode>(){

            @Override
            public int compare(FlowNode node1, FlowNode node2) {
                return Integer.compare(this.parseIota(node1), this.parseIota(node2));
            }

            private int parseIota(FlowNode node) {
                try {
                    return Integer.parseInt(node.getId());
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        });
        if (run.getExecution() != null) {
            Iterables.addAll(nodeTreeSet, (Iterable)new FlowGraphWalker(run.getExecution()));
        }
        this.sortedNodes = Collections.unmodifiableList(new ArrayList<FlowNode>(nodeTreeSet));
        this.build();
    }

    private void build() {
        FlowNode previousStage = null;
        FlowNode previousBranch = null;
        int count = 0;
        for (FlowNode node : this.sortedNodes) {
            if (!PipelineNodeUtil.isStage(node) && !PipelineNodeUtil.isParallelBranch(node)) continue;
            boolean nestedInParallel = PipelineNodeUtil.isNestedInParallel(this.sortedNodes, node);
            if (PipelineNodeUtil.isStage(node) && !nestedInParallel) {
                this.addChild(node, null);
                if (previousBranch != null) {
                    List<FlowNode> branches = this.parentToChildrenMap.get(previousStage);
                    for (FlowNode n : branches) {
                        this.addChild(n, node);
                    }
                    previousBranch = null;
                } else if (previousStage != null) {
                    this.nodeStatusMap.put(previousStage, new NodeRunStatus(this.sortedNodes.get(count - 1)));
                    this.addChild(previousStage, node);
                } else {
                    this.addChild(node, null);
                }
                previousStage = node;
            } else if (PipelineNodeUtil.isParallelBranch(node) && !nestedInParallel) {
                FlowNode endNode;
                this.addChild(node, null);
                if (previousStage != null) {
                    this.addChild(previousStage, node);
                }
                if ((endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, node)) != null) {
                    this.nodeStatusMap.put(node, new NodeRunStatus(endNode));
                } else {
                    this.nodeStatusMap.put(node, new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.RUNNING));
                }
                previousBranch = node;
            }
            ++count;
        }
        int size = this.parentToChildrenMap.keySet().size();
        if (size > 0) {
            NodeRunStatus runStatus = PipelineNodeUtil.getStatus(this.run);
            FlowNode lastNode = this.getLastStageNode();
            this.nodeStatusMap.put(lastNode, runStatus);
        }
    }

    public FlowNode getNodeById(String id) {
        for (FlowNode node : this.sortedNodes) {
            if (!node.getId().equals(id)) continue;
            return node;
        }
        return null;
    }

    public List<FlowNode> getSteps(FlowNode node) {
        if (PipelineNodeUtil.isStage(node)) {
            return this.getStageSteps(node);
        }
        if (PipelineNodeUtil.isParallelBranch(node)) {
            return this.getParallelBranchSteps(node);
        }
        return Collections.emptyList();
    }

    public List<FlowNode> getStageSteps(FlowNode p) {
        ArrayList<FlowNode> steps = new ArrayList<FlowNode>();
        int i = this.sortedNodes.indexOf(p);
        if (i >= 0 && PipelineNodeUtil.isStage(p)) {
            FlowNode c;
            FlowNode end = PipelineNodeUtil.getStepEndNode(this.sortedNodes, p);
            for (int j = i + 1; j < this.sortedNodes.size() && (!PipelineNodeUtil.isStage(c = this.sortedNodes.get(j)) || PipelineNodeUtil.isInBlock(p, end, c)); ++j) {
                if (!(c instanceof StepAtomNode)) continue;
                steps.add(c);
            }
        }
        return steps;
    }

    public List<FlowNode> getAllSteps() {
        ArrayList<FlowNode> steps = new ArrayList<FlowNode>();
        for (FlowNode c : this.sortedNodes) {
            if (!(c instanceof StepAtomNode) || PipelineNodeUtil.isStage(c)) continue;
            steps.add(c);
        }
        return steps;
    }

    public List<FlowNode> getParallelBranchSteps(FlowNode p) {
        ArrayList<FlowNode> steps = new ArrayList<FlowNode>();
        int i = this.sortedNodes.indexOf(p);
        if (i >= 0 && PipelineNodeUtil.isParallelBranch(p)) {
            FlowNode end = PipelineNodeUtil.getStepEndNode(this.sortedNodes, p);
            for (int j = i + 1; j < this.sortedNodes.size(); ++j) {
                FlowNode c = this.sortedNodes.get(j);
                if (c.equals((Object)end)) {
                    this.nodeStatusMap.put(p, new NodeRunStatus(end));
                    break;
                }
                if (PipelineNodeUtil.isParallelBranch(c) || !PipelineNodeUtil.isInBlock(p, end, c) || !(c instanceof StepAtomNode)) continue;
                steps.add(c);
                FlowNode endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, c);
                if (endNode == null) continue;
                this.nodeStatusMap.put(c, new NodeRunStatus(endNode));
            }
        }
        return steps;
    }

    public List<BluePipelineNode> union(PipelineNodeGraphBuilder other, Link parentLink) {
        Map<FlowNode, List<FlowNode>> futureNodes = other.parentToChildrenMap;
        if (this.parentToChildrenMap.size() < futureNodes.size()) {
            ImmutableList nodes = ImmutableList.copyOf(this.parentToChildrenMap.keySet());
            ImmutableList thatNodes = ImmutableList.copyOf(futureNodes.keySet());
            int currentNodeSize = nodes.size();
            for (int i = nodes.size(); i < futureNodes.size(); ++i) {
                InactiveFlowNodeWrapper n = new InactiveFlowNodeWrapper((FlowNode)thatNodes.get(i));
                if (currentNodeSize > 0 && i == currentNodeSize) {
                    FlowNode parent;
                    FlowNode latestNode = (FlowNode)nodes.get(currentNodeSize - 1);
                    if (PipelineNodeUtil.isStage(latestNode)) {
                        this.addChild(latestNode, n);
                    } else if (PipelineNodeUtil.isParallelBranch(latestNode) && (parent = this.getParentStageOfBranch(latestNode)) != null) {
                        List<FlowNode> children = this.parentToChildrenMap.get(parent);
                        for (FlowNode c : children) {
                            if (!PipelineNodeUtil.isParallelBranch(c)) continue;
                            this.addChild(c, n);
                        }
                    }
                }
                this.parentToChildrenMap.put(n, futureNodes.get(n.inactiveNode));
            }
        }
        return this.getPipelineNodes(parentLink);
    }

    public List<BluePipelineNode> getPipelineNodes(Link parentLink) {
        ArrayList<BluePipelineNode> nodes = new ArrayList<BluePipelineNode>();
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            NodeRunStatus status = this.nodeStatusMap.get(n);
            if (!this.isExecuted(n)) {
                status = new NodeRunStatus(BlueRun.BlueRunResult.UNKNOWN, BlueRun.BlueRunState.QUEUED);
            } else if (status == null) {
                status = this.getEffectiveBranchStatus(n);
            }
            nodes.add(new PipelineNodeImpl(this.run, n, status, this, parentLink));
        }
        return nodes;
    }

    public List<FlowNode> getChildren(FlowNode parent) {
        return this.parentToChildrenMap.get(parent);
    }

    @Nullable
    public Long getDurationInMillis(FlowNode node) {
        int i;
        long startTime = TimingAction.getStartTime((FlowNode)node);
        if (startTime == 0L) {
            return null;
        }
        if (PipelineNodeUtil.isStage(node)) {
            boolean lookForNextStage = false;
            for (FlowNode n : this.parentToChildrenMap.keySet()) {
                if (n.equals((Object)node)) {
                    lookForNextStage = true;
                    continue;
                }
                if (!lookForNextStage || !PipelineNodeUtil.isStage(n)) continue;
                return TimingAction.getStartTime((FlowNode)n) - startTime;
            }
        } else if (PipelineNodeUtil.isParallelBranch(node)) {
            FlowNode endNode = PipelineNodeUtil.getStepEndNode(this.sortedNodes, node);
            if (endNode != null) {
                return TimingAction.getStartTime((FlowNode)endNode) - startTime;
            }
        } else if (node instanceof StepAtomNode && (i = this.sortedNodes.indexOf(node)) >= 0 && i + 1 < this.sortedNodes.size()) {
            return TimingAction.getStartTime((FlowNode)this.sortedNodes.get(i + 1)) - startTime;
        }
        return this.run.getExecution().isComplete() ? this.run.getDuration() + this.run.getStartTimeInMillis() - startTime : System.currentTimeMillis() - startTime;
    }

    private boolean isEnd(FlowNode n) {
        return n instanceof StepEndNode;
    }

    private FlowNode getLastNode() {
        if (this.parentToChildrenMap.keySet().isEmpty()) {
            return null;
        }
        FlowNode node = null;
        Iterator<FlowNode> iterator = this.parentToChildrenMap.keySet().iterator();
        while (iterator.hasNext()) {
            FlowNode n;
            node = n = iterator.next();
        }
        return node;
    }

    private FlowNode getParentStageOfBranch(FlowNode node) {
        if (node.getParents().size() == 0) {
            return null;
        }
        FlowNode p = (FlowNode)node.getParents().get(0);
        if (PipelineNodeUtil.isStage(p)) {
            return p;
        }
        return this.getParentStageOfBranch(p);
    }

    private FlowNode getLastStageNode() {
        if (this.parentToChildrenMap.keySet().isEmpty()) {
            return null;
        }
        FlowNode node = null;
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isStage(n)) continue;
            node = n;
        }
        return node;
    }

    private FlowNode getLastBranchNode() {
        if (this.parentToChildrenMap.keySet().isEmpty()) {
            return null;
        }
        FlowNode node = null;
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isParallelBranch(n)) continue;
            node = n;
        }
        return node;
    }

    private NodeRunStatus getEffectiveBranchStatus(FlowNode n) {
        List<FlowNode> children = this.parentToChildrenMap.get(n);
        BlueRun.BlueRunResult result = BlueRun.BlueRunResult.SUCCESS;
        BlueRun.BlueRunState state = BlueRun.BlueRunState.FINISHED;
        boolean atLeastOneBranchDidNotSucceed = false;
        boolean atLeastOneBranchisUnknown = false;
        for (FlowNode c : children) {
            NodeRunStatus s;
            if (!PipelineNodeUtil.isParallelBranch(c) || (s = this.nodeStatusMap.get(c)) == null) continue;
            if (!atLeastOneBranchDidNotSucceed && s.getResult() == BlueRun.BlueRunResult.FAILURE || s.getResult() == BlueRun.BlueRunResult.UNSTABLE) {
                atLeastOneBranchDidNotSucceed = true;
                result = s.getResult();
            }
            if (s.getResult() == BlueRun.BlueRunResult.UNKNOWN) {
                atLeastOneBranchisUnknown = true;
            }
            if (s.getState() == BlueRun.BlueRunState.FINISHED || state == BlueRun.BlueRunState.RUNNING) continue;
            state = s.getState();
        }
        if (!atLeastOneBranchDidNotSucceed && atLeastOneBranchisUnknown) {
            result = BlueRun.BlueRunResult.UNKNOWN;
        }
        return new NodeRunStatus(result, state);
    }

    private boolean isExecuted(FlowNode node) {
        return NotExecutedNodeAction.isExecuted((FlowNode)node);
    }

    private List<FlowNode> addChild(FlowNode parent, FlowNode child) {
        List<FlowNode> children = this.parentToChildrenMap.get(parent);
        if (children == null) {
            children = new ArrayList<FlowNode>();
            this.parentToChildrenMap.put(parent, children);
        }
        if (child != null) {
            children.add(child);
        }
        return children;
    }

    public void dumpNodes(List<FlowNode> nodes) {
        for (FlowNode n : nodes) {
            System.out.println(String.format("id: %s, name: %s, startTime: %s, type: %s", n.getId(), n.getDisplayName(), TimingAction.getStartTime((FlowNode)n), n.getClass()));
        }
    }

    public List<FlowNode> getSages() {
        ArrayList<FlowNode> stages = new ArrayList<FlowNode>();
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isStage(n)) continue;
            stages.add(n);
        }
        return stages;
    }

    public List<FlowNode> getParallelBranches() {
        ArrayList<FlowNode> parallel = new ArrayList<FlowNode>();
        for (FlowNode n : this.parentToChildrenMap.keySet()) {
            if (!PipelineNodeUtil.isParallelBranch(n)) continue;
            parallel.add(n);
        }
        return parallel;
    }

    public static class InactiveFlowNodeWrapper
    extends FlowNode {
        private final FlowNode inactiveNode;

        public InactiveFlowNodeWrapper(FlowNode node) {
            super(node.getExecution(), node.getId(), new FlowNode[0]);
            this.inactiveNode = node;
        }

        protected String getTypeDisplayName() {
            return PipelineNodeUtil.getDisplayName(this.inactiveNode);
        }
    }

    public static class NodeRunStatus {
        private final BlueRun.BlueRunResult result;
        private final BlueRun.BlueRunState state;

        public NodeRunStatus(FlowNode endNode) {
            if (endNode.getError() != null) {
                this.result = BlueRun.BlueRunResult.FAILURE;
                this.state = endNode.isRunning() ? BlueRun.BlueRunState.RUNNING : BlueRun.BlueRunState.FINISHED;
            } else if (endNode.isRunning()) {
                this.result = BlueRun.BlueRunResult.UNKNOWN;
                this.state = BlueRun.BlueRunState.RUNNING;
            } else if (NotExecutedNodeAction.isExecuted((FlowNode)endNode)) {
                this.result = PipelineNodeUtil.getStatus(endNode.getError());
                this.state = BlueRun.BlueRunState.FINISHED;
            } else {
                this.result = BlueRun.BlueRunResult.NOT_BUILT;
                this.state = BlueRun.BlueRunState.QUEUED;
            }
        }

        public NodeRunStatus(BlueRun.BlueRunResult result, BlueRun.BlueRunState state) {
            this.result = result;
            this.state = state;
        }

        public BlueRun.BlueRunResult getResult() {
            return this.result;
        }

        public BlueRun.BlueRunState getState() {
            return this.state;
        }
    }
}

