/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import io.jenkins.blueocean.auth.jwt.JwtToken;
import io.jenkins.blueocean.auth.jwt.SigningKey;
import io.jenkins.blueocean.auth.jwt.SigningPublicKey;
import javax.annotation.CheckForNull;

public abstract class JwtSigningKeyProvider
implements ExtensionPoint {
    @CheckForNull
    public abstract SigningKey select(JwtToken var1);

    @CheckForNull
    public abstract SigningPublicKey getPublicKey(String var1);

    public static ExtensionList<JwtSigningKeyProvider> all() {
        return ExtensionList.lookup(JwtSigningKeyProvider.class);
    }

    @CheckForNull
    public static SigningPublicKey toPublicKey(String keyId) {
        for (JwtSigningKeyProvider provider : JwtSigningKeyProvider.all()) {
            SigningPublicKey key = provider.getPublicKey(keyId);
            if (key == null) continue;
            return key;
        }
        return null;
    }
}

