/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt;

import com.google.common.collect.ImmutableList;
import hudson.remoting.Base64;
import java.security.interfaces.RSAPublicKey;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.WebMethod;

public class SigningPublicKey {
    private final String kid;
    private final RSAPublicKey key;

    public SigningPublicKey(String kid, RSAPublicKey key) {
        this.kid = kid;
        this.key = key;
    }

    public String getKid() {
        return this.kid;
    }

    public RSAPublicKey getKey() {
        return this.key;
    }

    @WebMethod(name={""})
    public JSONObject asJSON() {
        JSONObject jwk = new JSONObject();
        jwk.put("kty", (Object)"RSA");
        jwk.put("alg", (Object)"RS256");
        jwk.put("kid", (Object)this.kid);
        jwk.put("use", (Object)"sig");
        jwk.put("key_ops", (Object)ImmutableList.of((Object)"verify"));
        jwk.put("n", (Object)Base64.encode((byte[])this.key.getModulus().toByteArray()));
        jwk.put("e", (Object)Base64.encode((byte[])this.key.getPublicExponent().toByteArray()));
        return jwk;
    }
}

