/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import hudson.Extension;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationStore;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationStoreFactory;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;

@Extension(ordinal=0.0)
public class SimpleJwtAuthenticationStore
extends JwtAuthenticationStoreFactory
implements JwtAuthenticationStore {
    private final ConcurrentMap<String, Authentication> authenticationMap = new ConcurrentHashMap<String, Authentication>();

    public void add(String id, Authentication authentication) {
        this.authenticationMap.putIfAbsent(id, authentication);
    }

    public Authentication get(String id) {
        return (Authentication)this.authenticationMap.get(id);
    }

    @Override
    public Authentication getAuthentication(Map<String, Object> claims) {
        Map authProvider;
        Map context = (Map)claims.get("context");
        if (context != null && context.get("authProvider") != null && (authProvider = (Map)context.get("authProvider")).get("id") != null) {
            long expiryTime;
            String id = (String)authProvider.get("id");
            Authentication authentication = (Authentication)this.authenticationMap.get(id);
            if (authentication != null && (expiryTime = ((Long)claims.get("exp")).longValue()) < System.currentTimeMillis() / 1000L) {
                this.authenticationMap.remove(id);
                return null;
            }
            return authentication;
        }
        return null;
    }

    @Override
    public void store(Authentication authentication, Map<String, Object> claims) {
        String authenticationId = UUID.randomUUID().toString().replace("-", "");
        this.add(authenticationId, authentication);
        JSONObject provider = new JSONObject();
        provider.put("id", (Object)authenticationId);
        claims.put("authProvider", provider);
    }

    @Override
    public JwtAuthenticationStore getJwtAuthenticationStore(Map<String, Object> claims) {
        Map context = (Map)claims.get("context");
        if (context != null && context.get("authProvider") != null) {
            return this;
        }
        return null;
    }

    @Override
    public JwtAuthenticationStore getJwtAuthenticationStore(Authentication authentication) {
        return this;
    }
}

