/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import hudson.Extension;
import hudson.Plugin;
import hudson.model.User;
import hudson.tasks.Mailer;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationService;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationStore;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationStoreFactory;
import io.jenkins.blueocean.auth.jwt.JwtToken;
import io.jenkins.blueocean.auth.jwt.SigningPublicKey;
import io.jenkins.blueocean.auth.jwt.impl.SigningKeyProviderImpl;
import io.jenkins.blueocean.auth.jwt.impl.SimpleJwtAuthenticationStore;
import io.jenkins.blueocean.commons.ServiceException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class JwtAuthenticationServiceImpl
extends JwtAuthenticationService {
    private static final Logger LOGGER = Logger.getLogger(JwtAuthenticationServiceImpl.class.getName());
    private static int DEFAULT_EXPIRY_IN_SEC = 1800;
    private static int DEFAULT_MAX_EXPIRY_TIME_IN_MIN = 480;
    private static int DEFAULT_NOT_BEFORE_IN_SEC = 30;

    @Override
    public JwtToken getToken(@Nullable @QueryParameter(value="expiryTimeInMins") Integer expiryTimeInMins, @Nullable @QueryParameter(value="maxExpiryTimeInMins") Integer maxExpiryTimeInMins) {
        long expiryTime = Long.getLong("EXPIRY_TIME_IN_MINS", DEFAULT_EXPIRY_IN_SEC);
        int maxExpiryTime = Integer.getInteger("MAX_EXPIRY_TIME_IN_MINS", DEFAULT_MAX_EXPIRY_TIME_IN_MIN);
        if (maxExpiryTimeInMins != null) {
            maxExpiryTime = maxExpiryTimeInMins;
        }
        if (expiryTimeInMins != null) {
            if (expiryTimeInMins > maxExpiryTime) {
                throw new ServiceException.BadRequestException(String.format("expiryTimeInMins %s can't be greater than %s", expiryTimeInMins, maxExpiryTime));
            }
            expiryTime = expiryTimeInMins * 60;
        }
        Authentication authentication = Jenkins.getAuthentication();
        String userId = authentication.getName();
        User user = User.get((String)userId, (boolean)false, Collections.emptyMap());
        String email = null;
        String fullName = null;
        if (user != null) {
            fullName = user.getFullName();
            userId = user.getId();
            Mailer.UserProperty p = (Mailer.UserProperty)user.getProperty(Mailer.UserProperty.class);
            if (p != null) {
                email = p.getAddress();
            }
        }
        Plugin plugin = Jenkins.getInstance().getPlugin("blueocean-jwt");
        String issuer = "blueocean-jwt:" + (plugin != null ? plugin.getWrapper().getVersion() : "");
        JwtToken jwtToken = new JwtToken();
        jwtToken.claim.put("jti", (Object)UUID.randomUUID().toString().replace("-", ""));
        jwtToken.claim.put("iss", (Object)issuer);
        jwtToken.claim.put("sub", (Object)userId);
        jwtToken.claim.put("name", (Object)fullName);
        long currentTime = System.currentTimeMillis() / 1000L;
        jwtToken.claim.put("iat", (Object)currentTime);
        jwtToken.claim.put("exp", (Object)(currentTime + expiryTime));
        jwtToken.claim.put("nbf", (Object)(currentTime - (long)DEFAULT_NOT_BEFORE_IN_SEC));
        JSONObject context = new JSONObject();
        JSONObject userObject = new JSONObject();
        userObject.put("id", (Object)userId);
        userObject.put("fullName", (Object)fullName);
        userObject.put("email", (Object)email);
        JwtAuthenticationStore authenticationStore = JwtAuthenticationServiceImpl.getJwtStore(authentication);
        authenticationStore.store(authentication, (Map<String, Object>)context);
        context.put("user", (Object)userObject);
        jwtToken.claim.put("context", (Object)context);
        return jwtToken;
    }

    @Override
    public JSONObject getJwkSet() {
        JSONObject jwks = new JSONObject();
        JSONArray keys = new JSONArray();
        for (int i = 0; i <= 12; ++i) {
            String keyId = SigningKeyProviderImpl.DATE_FORMAT.format(Instant.now().minus(ChronoUnit.MONTHS.getDuration().multipliedBy(i)));
            try {
                SigningPublicKey signingKey = this.getJwks(keyId);
                if (signingKey == null) continue;
                keys.add((Object)signingKey.asJSON());
                continue;
            }
            catch (ServiceException e) {
                LOGGER.log(Level.WARNING, String.format("Error reading RSA key for id %s: %s", keyId, e.getMessage()), e);
            }
        }
        jwks.put("keys", (Object)keys);
        return jwks;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "BlueOcean Jwt endpoint";
    }

    public static JwtAuthenticationStore getJwtStore(Authentication authentication) {
        JwtAuthenticationStore jwtAuthenticationStore = null;
        for (JwtAuthenticationStoreFactory factory : JwtAuthenticationStoreFactory.all()) {
            if (factory instanceof SimpleJwtAuthenticationStore) {
                jwtAuthenticationStore = factory.getJwtAuthenticationStore(authentication);
                continue;
            }
            JwtAuthenticationStore authenticationStore = factory.getJwtAuthenticationStore(authentication);
            if (authenticationStore == null) continue;
            return authenticationStore;
        }
        return jwtAuthenticationStore;
    }
}

