/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import hudson.Extension;
import hudson.model.User;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationStore;
import io.jenkins.blueocean.auth.jwt.JwtAuthenticationStoreFactory;
import io.jenkins.blueocean.auth.jwt.JwtSigningKeyProvider;
import io.jenkins.blueocean.auth.jwt.JwtTokenVerifier;
import io.jenkins.blueocean.auth.jwt.SigningPublicKey;
import io.jenkins.blueocean.auth.jwt.impl.SimpleJwtAuthenticationStore;
import io.jenkins.blueocean.commons.ServiceException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.lang.JoseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension(ordinal=-9999.0)
public class JwtTokenVerifierImpl
extends JwtTokenVerifier {
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenVerifierImpl.class);

    @Override
    public Authentication verify(HttpServletRequest request) {
        return this.validate(request);
    }

    @CheckForNull
    private Authentication validate(HttpServletRequest request) {
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null || !authHeader.startsWith("Bearer ")) {
            return null;
        }
        String token = authHeader.substring("Bearer ".length());
        JsonWebStructure jws = this.parse(token);
        if (jws == null) {
            return null;
        }
        try {
            String alg = jws.getAlgorithmHeaderValue();
            if (alg == null || !alg.equals("RS256")) {
                logger.error(String.format("Invalid JWT token: unsupported algorithm in header, found %s, expected %s", alg, "RS256"));
                throw new ServiceException.UnauthorizedException("Invalid JWT token");
            }
            String kid = jws.getKeyIdHeaderValue();
            if (kid == null) {
                logger.error("Invalid JWT token: missing kid");
                throw new ServiceException.UnauthorizedException("Invalid JWT token");
            }
            SigningPublicKey publicKey = JwtSigningKeyProvider.toPublicKey(kid);
            if (publicKey == null) {
                throw new ServiceException.UnexpectedErrorException("Invalid kid=" + kid);
            }
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setRequireExpirationTime().setRequireJwtId().setAllowedClockSkewInSeconds(30).setRequireSubject().setVerificationKey((Key)publicKey.getKey()).build();
            try {
                JwtContext context = jwtConsumer.process(token);
                JwtClaims claims = context.getJwtClaims();
                String subject = claims.getSubject();
                if (subject.equals("anonymous")) {
                    return Jenkins.ANONYMOUS;
                }
                JwtAuthenticationStore authenticationStore = JwtTokenVerifierImpl.getJwtStore(claims.getClaimsMap());
                Authentication authentication = authenticationStore.getAuthentication(claims.getClaimsMap());
                NumericDate expirationTime = claims.getExpirationTime();
                if (expirationTime.isBefore(NumericDate.now())) {
                    throw new ServiceException.UnauthorizedException("Invalid JWT token: expired");
                }
                return authentication;
            }
            catch (InvalidJwtException e) {
                logger.error("Invalid JWT token: " + e.getMessage(), (Throwable)e);
                throw new ServiceException.UnauthorizedException("Invalid JWT token");
            }
            catch (MalformedClaimException e) {
                logger.error(String.format("Error reading sub header for token %s", jws.getPayload()), (Throwable)e);
                throw new ServiceException.UnauthorizedException("Invalid JWT token: malformed claim");
            }
        }
        catch (JoseException e) {
            logger.error("Error parsing JWT token: " + e.getMessage(), (Throwable)e);
            throw new ServiceException.UnauthorizedException("Invalid JWT Token: " + e.getMessage());
        }
    }

    private JsonWebStructure parse(String token) {
        try {
            return JsonWebStructure.fromCompactSerialization((String)token);
        }
        catch (JoseException e) {
            return null;
        }
    }

    private static JwtAuthenticationStore getJwtStore(Map<String, Object> claims) {
        JwtAuthenticationStore jwtAuthenticationStore = null;
        for (JwtAuthenticationStoreFactory factory : JwtAuthenticationStoreFactory.all()) {
            if (factory instanceof SimpleJwtAuthenticationStore) {
                jwtAuthenticationStore = factory.getJwtAuthenticationStore(claims);
                continue;
            }
            JwtAuthenticationStore authenticationStore = factory.getJwtAuthenticationStore(claims);
            if (authenticationStore == null) continue;
            return authenticationStore;
        }
        return jwtAuthenticationStore;
    }

    public static class JwtAuthentication
    extends AbstractAuthenticationToken {
        private final String name;
        private final GrantedAuthority[] grantedAuthorities;

        public JwtAuthentication(String subject) {
            User user = User.get((String)subject, (boolean)false, Collections.emptyMap());
            if (user == null) {
                throw new ServiceException.UnauthorizedException("Invalid JWT token: subject " + subject + " not found");
            }
            UserDetails d = Jenkins.getInstance().getSecurityRealm().loadUserByUsername(user.getId());
            this.grantedAuthorities = d.getAuthorities();
            this.name = subject;
            super.setAuthenticated(true);
        }

        public Object getCredentials() {
            return "";
        }

        public Object getPrincipal() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public GrantedAuthority[] getAuthorities() {
            return Arrays.copyOf(this.grantedAuthorities, this.grantedAuthorities.length);
        }
    }
}

