/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import hudson.Extension;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import io.jenkins.blueocean.auth.jwt.JwtTokenVerifier;
import io.jenkins.blueocean.commons.BlueOceanConfigProperties;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.context.SecurityContextImpl;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.Stapler;

@Extension
public class JwtAuthenticationFilter
implements Filter {
    private static final String JWT_TOKEN_VALIDATED = JwtAuthenticationFilter.class.getName() + ".validated";

    @Initializer(fatal=false)
    public static void init() throws ServletException {
        PluginServletFilter.addFilter((Filter)new JwtAuthenticationFilter());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        if (!this.shouldApply(request)) {
            chain.doFilter(req, rsp);
            return;
        }
        Authentication token = this.verifyToken(request);
        if (token == null) {
            chain.doFilter(req, rsp);
            return;
        }
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication(token);
        SecurityContext previous = SecurityContextHolder.getContext();
        SecurityContextHolder.setContext((SecurityContext)sc);
        request.setAttribute(JWT_TOKEN_VALIDATED, (Object)true);
        try {
            chain.doFilter(req, rsp);
        }
        finally {
            if (previous != null) {
                SecurityContextHolder.setContext((SecurityContext)previous);
            } else {
                SecurityContextHolder.clearContext();
            }
        }
    }

    private Authentication verifyToken(HttpServletRequest request) {
        for (JwtTokenVerifier verifier : JwtTokenVerifier.all()) {
            Authentication token = verifier.verify(request);
            if (token == null) continue;
            return token;
        }
        return null;
    }

    protected boolean shouldApply(HttpServletRequest req) {
        if (!BlueOceanConfigProperties.BLUEOCEAN_FEATURE_JWT_AUTHENTICATION) {
            return false;
        }
        String path = req.getRequestURI().substring(req.getContextPath().length());
        if (!StringUtils.isBlank((String)path)) {
            path = path.replaceAll("//+", "/");
        }
        return path.startsWith("/blue/") || path.startsWith("/sse-gateway/");
    }

    public void destroy() {
    }

    public static boolean didRequestHaveValidatedJwtToken() {
        return Boolean.TRUE.equals(Stapler.getCurrentRequest().getAttribute(JWT_TOKEN_VALIDATED));
    }
}

