/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.blueocean.auth.jwt.impl;

import hudson.Extension;
import io.jenkins.blueocean.auth.jwt.JwtSigningKeyProvider;
import io.jenkins.blueocean.auth.jwt.JwtToken;
import io.jenkins.blueocean.auth.jwt.SigningKey;
import io.jenkins.blueocean.auth.jwt.SigningPublicKey;
import io.jenkins.blueocean.auth.jwt.impl.JwtRsaDigitalSignatureKey;
import io.jenkins.blueocean.commons.ServiceException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

@Extension(ordinal=-9999.0)
public class SigningKeyProviderImpl
extends JwtSigningKeyProvider {
    private static final Logger LOGGER = Logger.getLogger(SigningKeyProviderImpl.class.getName());
    private static final Pattern YYYYMM = Pattern.compile("[0-9]{6}");
    private final AtomicReference<JwtRsaDigitalSignatureKey> key = new AtomicReference();

    @Override
    public SigningKey select(JwtToken token) {
        String id = new SimpleDateFormat("yyyyMM").format(new Date());
        JwtRsaDigitalSignatureKey k = this.key.get();
        if (k == null || !k.getId().equals(id)) {
            k = new JwtRsaDigitalSignatureKey(id);
            this.key.set(k);
        }
        return k.toSigningKey();
    }

    @Override
    public SigningPublicKey getPublicKey(String kid) {
        if (!YYYYMM.matcher(kid).matches()) {
            return null;
        }
        JwtRsaDigitalSignatureKey key = new JwtRsaDigitalSignatureKey(kid);
        try {
            if (!key.exists()) {
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, String.format("Error reading RSA key for id %s: %s", kid, e.getMessage()), e);
            throw new ServiceException.UnexpectedErrorException("Unexpected error: " + e.getMessage(), (Throwable)e);
        }
        return new SigningPublicKey(kid, key.getPublicKey());
    }
}

